/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.Beta;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.ThreadSafe;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.AttributeUpdate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.DeleteItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Expected;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.GetItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Index;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.Item;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ItemCollection;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.KeyAttribute;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PrimaryKey;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.PutItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.QueryFilter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.QueryOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.RangeKeyCondition;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ScanFilter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.ScanOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.UpdateItemOutcome;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.DeleteItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.GetItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.PutItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.QueryApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.ScanApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.api.UpdateItemApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.DeleteItemImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.GetItemImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.InternalUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.PutItemImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.QueryImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.ScanImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.internal.UpdateItemImpl;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.DeleteItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.GetItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.PutItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.QuerySpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.ScanSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.UpdateItemSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.document.spec.UpdateTableSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.CreateGlobalSecondaryIndexAction;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DeleteTableResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.DescribeTableResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexDescription;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndexUpdate;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.IndexStatus;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableDescription;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.TableStatus;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.UpdateTableRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.UpdateTableResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.DeleteItemExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.GetItemExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.QueryExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.ScanExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.xspec.UpdateItemExpressionSpec;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.Waiter;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.WaiterParameters;

@ThreadSafe
public class Table
implements PutItemApi,
GetItemApi,
QueryApi,
ScanApi,
UpdateItemApi,
DeleteItemApi {
    private static final long SLEEP_TIME_MILLIS = 5000L;
    private final String tableName;
    private final AmazonDynamoDB client;
    private volatile TableDescription tableDescription;
    private final PutItemImpl putItemDelegate;
    private final GetItemImpl getItemDelegate;
    private final UpdateItemImpl updateItemDelegate;
    private final DeleteItemImpl deleteItemDelegate;
    private final QueryImpl queryDelegate;
    private final ScanImpl scanDelegate;

    public Table(AmazonDynamoDB client, String tableName) {
        this(client, tableName, null);
    }

    public Table(AmazonDynamoDB client, String tableName, TableDescription tableDescription) {
        if (client == null) {
            throw new IllegalArgumentException("client must be specified");
        }
        if (tableName == null || tableName.trim().length() == 0) {
            throw new IllegalArgumentException("table name must not be null or empty");
        }
        this.client = client;
        this.tableName = tableName;
        this.tableDescription = tableDescription;
        this.putItemDelegate = new PutItemImpl(client, this);
        this.getItemDelegate = new GetItemImpl(client, this);
        this.updateItemDelegate = new UpdateItemImpl(client, this);
        this.deleteItemDelegate = new DeleteItemImpl(client, this);
        this.queryDelegate = new QueryImpl(client, this);
        this.scanDelegate = new ScanImpl(client, this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public TableDescription getDescription() {
        return this.tableDescription;
    }

    public TableDescription describe() {
        DescribeTableResult result = this.client.describeTable(InternalUtils.applyUserAgent(new DescribeTableRequest(this.tableName)));
        this.tableDescription = result.getTable();
        return this.tableDescription;
    }

    public Index getIndex(String indexName) {
        return new Index(this.client, indexName, this);
    }

    @Override
    public PutItemOutcome putItem(Item item) {
        return this.putItemDelegate.putItem(item);
    }

    @Override
    public PutItemOutcome putItem(Item item, Expected ... expected) {
        return this.putItemDelegate.putItem(item, expected);
    }

    @Override
    public PutItemOutcome putItem(Item item, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.putItemDelegate.putItem(item, conditionExpression, nameMap, valueMap);
    }

    @Override
    public PutItemOutcome putItem(PutItemSpec spec) {
        return this.putItemDelegate.putItem(spec);
    }

    @Override
    public GetItemOutcome getItemOutcome(KeyAttribute ... primaryKeyComponents) {
        return this.getItemDelegate.getItemOutcome(primaryKeyComponents);
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey) {
        return this.getItemDelegate.getItemOutcome(primaryKey);
    }

    @Override
    public GetItemOutcome getItemOutcome(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(primaryKey, projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(GetItemSpec params) {
        return this.getItemDelegate.getItemOutcome(params);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(primaryKey, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(primaryKey, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(primaryKey, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(PrimaryKey primaryKey, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(primaryKey, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(UpdateItemSpec updateItemSpec) {
        return this.updateItemDelegate.updateItem(updateItemSpec);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey) {
        return this.queryDelegate.query(hashKey);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(KeyAttribute hashKey, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKey, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(QuerySpec spec) {
        return this.queryDelegate.query(spec);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanFilter ... scanFilters) {
        return this.scanDelegate.scan(scanFilters);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.scanDelegate.scan(filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<ScanOutcome> scan(ScanSpec params) {
        return this.scanDelegate.scan(params);
    }

    @Beta
    public ItemCollection<ScanOutcome> scan(ScanExpressionSpec scanExpressions) {
        return this.scanDelegate.scan(new ScanSpec().withProjectionExpression(scanExpressions.getProjectionExpression()).withFilterExpression(scanExpressions.getFilterExpression()).withNameMap(scanExpressions.getNameMap()).withValueMap(scanExpressions.getValueMap()));
    }

    @Override
    public DeleteItemOutcome deleteItem(KeyAttribute ... primaryKeyComponents) {
        return this.deleteItemDelegate.deleteItem(primaryKeyComponents);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey) {
        return this.deleteItemDelegate.deleteItem(primaryKey);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(primaryKey, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(primaryKey, conditionExpression, nameMap, valueMap);
    }

    @Beta
    public DeleteItemOutcome deleteItem(PrimaryKey primaryKey, DeleteItemExpressionSpec conditionExpressions) {
        return this.deleteItemDelegate.deleteItem(primaryKey, conditionExpressions.getConditionExpression(), conditionExpressions.getNameMap(), conditionExpressions.getValueMap());
    }

    @Override
    public DeleteItemOutcome deleteItem(DeleteItemSpec spec) {
        return this.deleteItemDelegate.deleteItem(spec);
    }

    public TableDescription updateTable(UpdateTableSpec spec) {
        UpdateTableRequest req = (UpdateTableRequest)spec.getRequest();
        req.setTableName(this.getTableName());
        UpdateTableResult result = this.client.updateTable(req);
        this.tableDescription = result.getTableDescription();
        return this.tableDescription;
    }

    public Index createGSI(CreateGlobalSecondaryIndexAction create, AttributeDefinition hashKeyDefinition) {
        return this.doCreateGSI(create, hashKeyDefinition);
    }

    public Index createGSI(CreateGlobalSecondaryIndexAction create, AttributeDefinition hashKeyDefinition, AttributeDefinition rangeKeyDefinition) {
        return this.doCreateGSI(create, hashKeyDefinition, rangeKeyDefinition);
    }

    private Index doCreateGSI(CreateGlobalSecondaryIndexAction create, AttributeDefinition ... keyDefinitions) {
        UpdateTableSpec spec = new UpdateTableSpec().withAttributeDefinitions(keyDefinitions).withGlobalSecondaryIndexUpdates(new GlobalSecondaryIndexUpdate().withCreate(create));
        this.updateTable(spec);
        return this.getIndex(create.getIndexName());
    }

    public TableDescription updateTable(ProvisionedThroughput provisionedThroughput) {
        return this.updateTable(new UpdateTableSpec().withProvisionedThroughput(provisionedThroughput));
    }

    public TableDescription waitForActive() throws InterruptedException {
        Waiter<DescribeTableRequest> waiter = this.client.waiters().tableExists();
        try {
            waiter.run(new WaiterParameters<DescribeTableRequest>(new DescribeTableRequest(this.tableName)).withPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(5))));
            return this.describe();
        }
        catch (Exception exception) {
            this.describe();
            throw new IllegalArgumentException("Table " + this.tableName + " did not transition into ACTIVE state.", exception);
        }
    }

    public void waitForDelete() throws InterruptedException {
        Waiter<DescribeTableRequest> waiter = this.client.waiters().tableNotExists();
        try {
            waiter.run(new WaiterParameters<DescribeTableRequest>(new DescribeTableRequest(this.tableName)).withPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(25), new FixedDelayStrategy(5))));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Table " + this.tableName + " is not deleted.", exception);
        }
    }

    @Deprecated
    public TableDescription waitForActiveOrDelete() throws InterruptedException {
        try {
            while (true) {
                TableDescription desc;
                String status;
                if (TableStatus.fromValue(status = (desc = this.describe()).getTableStatus()) == TableStatus.ACTIVE) {
                    return desc;
                }
                Thread.sleep(5000L);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    @Deprecated
    public TableDescription waitForAllActiveOrDelete() throws InterruptedException {
        try {
            block2: while (true) {
                TableDescription desc;
                String status;
                if (TableStatus.fromValue(status = (desc = this.describe()).getTableStatus()) == TableStatus.ACTIVE) {
                    List<GlobalSecondaryIndexDescription> descriptions = desc.getGlobalSecondaryIndexes();
                    if (descriptions != null) {
                        for (GlobalSecondaryIndexDescription d : descriptions) {
                            status = d.getIndexStatus();
                            if (IndexStatus.fromValue(status) == IndexStatus.ACTIVE) continue;
                            Thread.sleep(5000L);
                            continue block2;
                        }
                    }
                    return desc;
                }
                Thread.sleep(5000L);
            }
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            return null;
        }
    }

    public DeleteTableResult delete() {
        return this.client.deleteTable(this.tableName);
    }

    @Override
    public Item getItem(KeyAttribute ... primaryKeyComponents) {
        return this.getItemDelegate.getItem(primaryKeyComponents);
    }

    @Override
    public Item getItem(PrimaryKey primaryKey) {
        return this.getItemDelegate.getItem(primaryKey);
    }

    @Override
    public Item getItem(PrimaryKey primaryKey, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(primaryKey, projectionExpression, nameMap);
    }

    @Override
    public Item getItem(GetItemSpec spec) {
        return this.getItemDelegate.getItem(spec);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryFilter ... queryFilters) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, queryFilters);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, nameMap, valueMap);
    }

    @Override
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, String filterExpression, String projectionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, filterExpression, projectionExpression, nameMap, valueMap);
    }

    @Beta
    public ItemCollection<QueryOutcome> query(String hashKeyName, Object hashKeyValue, RangeKeyCondition rangeKeyCondition, QueryExpressionSpec queryExpressions) {
        return this.queryDelegate.query(hashKeyName, hashKeyValue, rangeKeyCondition, queryExpressions.getFilterExpression(), queryExpressions.getProjectionExpression(), queryExpressions.getNameMap(), queryExpressions.getValueMap());
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Collection<Expected> expected, AttributeUpdate ... attributeUpdates) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, expected, attributeUpdates);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, updateExpression, nameMap, valueMap);
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Beta
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, UpdateItemExpressionSpec updateExpressions) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, updateExpressions.getUpdateExpression(), updateExpressions.getConditionExpression(), updateExpressions.getNameMap(), updateExpressions.getValueMap());
    }

    @Override
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String updateExpression, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, updateExpression, conditionExpression, nameMap, valueMap);
    }

    @Beta
    public UpdateItemOutcome updateItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, UpdateItemExpressionSpec updateExpressions) {
        return this.updateItemDelegate.updateItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, updateExpressions.getUpdateExpression(), updateExpressions.getConditionExpression(), updateExpressions.getNameMap(), updateExpressions.getValueMap());
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, projectionExpression, nameMap);
    }

    @Override
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpression, nameMap);
    }

    @Beta
    public GetItemOutcome getItemOutcome(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, GetItemExpressionSpec projectionExpressions) {
        return this.getItemDelegate.getItemOutcome(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpressions.getProjectionExpression(), projectionExpressions.getNameMap());
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, projectionExpression, nameMap);
    }

    @Override
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String projectionExpression, Map<String, String> nameMap) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpression, nameMap);
    }

    @Beta
    public Item getItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, GetItemExpressionSpec projectionExpressions) {
        return this.getItemDelegate.getItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, projectionExpressions.getProjectionExpression(), projectionExpressions.getNameMap());
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, Expected ... expected) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, expected);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, conditionExpression, nameMap, valueMap);
    }

    @Override
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, String conditionExpression, Map<String, String> nameMap, Map<String, Object> valueMap) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, conditionExpression, nameMap, valueMap);
    }

    @Beta
    public DeleteItemOutcome deleteItem(String hashKeyName, Object hashKeyValue, String rangeKeyName, Object rangeKeyValue, DeleteItemExpressionSpec conditionExpressions) {
        return this.deleteItemDelegate.deleteItem(hashKeyName, hashKeyValue, rangeKeyName, rangeKeyValue, conditionExpressions.getConditionExpression(), conditionExpressions.getNameMap(), conditionExpressions.getValueMap());
    }

    public String toString() {
        return "{" + this.tableName + ": " + this.tableDescription + "}";
    }
}

