/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers;

import java.nio.ByteBuffer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.datamodeling.unmarshallers.BUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.AttributeValue;

public class ByteArrayUnmarshaller
extends BUnmarshaller {
    private static final ByteArrayUnmarshaller INSTANCE = new ByteArrayUnmarshaller();

    public static ByteArrayUnmarshaller instance() {
        return INSTANCE;
    }

    private ByteArrayUnmarshaller() {
    }

    @Override
    public Object unmarshall(AttributeValue value) {
        ByteBuffer buffer = value.getB();
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] array = new byte[buffer.remaining()];
        buffer.get(array);
        return array;
    }
}

