/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters;

import java.util.concurrent.ExecutorService;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DescribeAlarmsRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DescribeAlarmsResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.AlarmExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.CompositeAlarmExists;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.waiters.DescribeAlarmsFunction;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.PollingStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.Waiter;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.WaiterBuilder;
import org.apache.flink.kinesis.shaded.com.amazonaws.waiters.WaiterExecutorServiceFactory;

public class AmazonCloudWatchWaiters {
    private final AmazonCloudWatch client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonCloudWatchWaiters");

    @SdkInternalApi
    public AmazonCloudWatchWaiters(AmazonCloudWatch client) {
        this.client = client;
    }

    public Waiter<DescribeAlarmsRequest> alarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new AlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeAlarmsRequest> compositeAlarmExists() {
        return new WaiterBuilder<DescribeAlarmsRequest, DescribeAlarmsResult>().withSdkFunction(new DescribeAlarmsFunction(this.client)).withAcceptors(new CompositeAlarmExists.IsTrueMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(40), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

