/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Range;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class RangeStaxUnmarshaller
implements Unmarshaller<Range, StaxUnmarshallerContext> {
    private static RangeStaxUnmarshaller instance;

    @Override
    public Range unmarshall(StaxUnmarshallerContext context) throws Exception {
        Range range = new Range();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return range;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("StartTime", targetDepth)) {
                    range.setStartTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("EndTime", targetDepth)) continue;
                range.setEndTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return range;
    }

    public static RangeStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new RangeStaxUnmarshaller();
        }
        return instance;
    }
}

