/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Dimension;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.Metric;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.DimensionStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class MetricStaxUnmarshaller
implements Unmarshaller<Metric, StaxUnmarshallerContext> {
    private static MetricStaxUnmarshaller instance;

    @Override
    public Metric unmarshall(StaxUnmarshallerContext context) throws Exception {
        Metric metric = new Metric();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metric;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Namespace", targetDepth)) {
                    metric.setNamespace(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricName", targetDepth)) {
                    metric.setMetricName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    metric.withDimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (!context.testExpression("Dimensions/member", targetDepth)) continue;
                metric.withDimensions(DimensionStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metric;
    }

    public static MetricStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricStaxUnmarshaller();
        }
        return instance;
    }
}

