/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform;

import javax.xml.stream.events.XMLEvent;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.MetricDataQuery;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.transform.MetricStatStaxUnmarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.StaxUnmarshallerContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Unmarshaller;

public class MetricDataQueryStaxUnmarshaller
implements Unmarshaller<MetricDataQuery, StaxUnmarshallerContext> {
    private static MetricDataQueryStaxUnmarshaller instance;

    @Override
    public MetricDataQuery unmarshall(StaxUnmarshallerContext context) throws Exception {
        MetricDataQuery metricDataQuery = new MetricDataQuery();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return metricDataQuery;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    metricDataQuery.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("MetricStat", targetDepth)) {
                    metricDataQuery.setMetricStat(MetricStatStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Expression", targetDepth)) {
                    metricDataQuery.setExpression(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Label", targetDepth)) {
                    metricDataQuery.setLabel(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ReturnData", targetDepth)) {
                    metricDataQuery.setReturnData(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Period", targetDepth)) {
                    metricDataQuery.setPeriod(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("AccountId", targetDepth)) continue;
                metricDataQuery.setAccountId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return metricDataQuery;
    }

    public static MetricDataQueryStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MetricDataQueryStaxUnmarshaller();
        }
        return instance;
    }
}

