/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonWebServiceRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.internal.SdkInternalList;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.DimensionFilter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.RecentlyActive;

public class ListMetricsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String namespace;
    private String metricName;
    private SdkInternalList<DimensionFilter> dimensions;
    private String nextToken;
    private String recentlyActive;
    private Boolean includeLinkedAccounts;
    private String owningAccount;

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ListMetricsRequest withNamespace(String namespace) {
        this.setNamespace(namespace);
        return this;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getMetricName() {
        return this.metricName;
    }

    public ListMetricsRequest withMetricName(String metricName) {
        this.setMetricName(metricName);
        return this;
    }

    public List<DimensionFilter> getDimensions() {
        if (this.dimensions == null) {
            this.dimensions = new SdkInternalList();
        }
        return this.dimensions;
    }

    public void setDimensions(Collection<DimensionFilter> dimensions) {
        if (dimensions == null) {
            this.dimensions = null;
            return;
        }
        this.dimensions = new SdkInternalList<DimensionFilter>(dimensions);
    }

    public ListMetricsRequest withDimensions(DimensionFilter ... dimensions) {
        if (this.dimensions == null) {
            this.setDimensions(new SdkInternalList<DimensionFilter>(dimensions.length));
        }
        for (DimensionFilter ele : dimensions) {
            this.dimensions.add(ele);
        }
        return this;
    }

    public ListMetricsRequest withDimensions(Collection<DimensionFilter> dimensions) {
        this.setDimensions(dimensions);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListMetricsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public void setRecentlyActive(String recentlyActive) {
        this.recentlyActive = recentlyActive;
    }

    public String getRecentlyActive() {
        return this.recentlyActive;
    }

    public ListMetricsRequest withRecentlyActive(String recentlyActive) {
        this.setRecentlyActive(recentlyActive);
        return this;
    }

    public ListMetricsRequest withRecentlyActive(RecentlyActive recentlyActive) {
        this.recentlyActive = recentlyActive.toString();
        return this;
    }

    public void setIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
        this.includeLinkedAccounts = includeLinkedAccounts;
    }

    public Boolean getIncludeLinkedAccounts() {
        return this.includeLinkedAccounts;
    }

    public ListMetricsRequest withIncludeLinkedAccounts(Boolean includeLinkedAccounts) {
        this.setIncludeLinkedAccounts(includeLinkedAccounts);
        return this;
    }

    public Boolean isIncludeLinkedAccounts() {
        return this.includeLinkedAccounts;
    }

    public void setOwningAccount(String owningAccount) {
        this.owningAccount = owningAccount;
    }

    public String getOwningAccount() {
        return this.owningAccount;
    }

    public ListMetricsRequest withOwningAccount(String owningAccount) {
        this.setOwningAccount(owningAccount);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNamespace() != null) {
            sb.append("Namespace: ").append(this.getNamespace()).append(",");
        }
        if (this.getMetricName() != null) {
            sb.append("MetricName: ").append(this.getMetricName()).append(",");
        }
        if (this.getDimensions() != null) {
            sb.append("Dimensions: ").append(this.getDimensions()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getRecentlyActive() != null) {
            sb.append("RecentlyActive: ").append(this.getRecentlyActive()).append(",");
        }
        if (this.getIncludeLinkedAccounts() != null) {
            sb.append("IncludeLinkedAccounts: ").append(this.getIncludeLinkedAccounts()).append(",");
        }
        if (this.getOwningAccount() != null) {
            sb.append("OwningAccount: ").append(this.getOwningAccount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricsRequest)) {
            return false;
        }
        ListMetricsRequest other = (ListMetricsRequest)obj;
        if (other.getNamespace() == null ^ this.getNamespace() == null) {
            return false;
        }
        if (other.getNamespace() != null && !other.getNamespace().equals(this.getNamespace())) {
            return false;
        }
        if (other.getMetricName() == null ^ this.getMetricName() == null) {
            return false;
        }
        if (other.getMetricName() != null && !other.getMetricName().equals(this.getMetricName())) {
            return false;
        }
        if (other.getDimensions() == null ^ this.getDimensions() == null) {
            return false;
        }
        if (other.getDimensions() != null && !other.getDimensions().equals(this.getDimensions())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getRecentlyActive() == null ^ this.getRecentlyActive() == null) {
            return false;
        }
        if (other.getRecentlyActive() != null && !other.getRecentlyActive().equals(this.getRecentlyActive())) {
            return false;
        }
        if (other.getIncludeLinkedAccounts() == null ^ this.getIncludeLinkedAccounts() == null) {
            return false;
        }
        if (other.getIncludeLinkedAccounts() != null && !other.getIncludeLinkedAccounts().equals(this.getIncludeLinkedAccounts())) {
            return false;
        }
        if (other.getOwningAccount() == null ^ this.getOwningAccount() == null) {
            return false;
        }
        return other.getOwningAccount() == null || other.getOwningAccount().equals(this.getOwningAccount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNamespace() == null ? 0 : this.getNamespace().hashCode());
        hashCode = 31 * hashCode + (this.getMetricName() == null ? 0 : this.getMetricName().hashCode());
        hashCode = 31 * hashCode + (this.getDimensions() == null ? 0 : this.getDimensions().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getRecentlyActive() == null ? 0 : this.getRecentlyActive().hashCode());
        hashCode = 31 * hashCode + (this.getIncludeLinkedAccounts() == null ? 0 : this.getIncludeLinkedAccounts().hashCode());
        hashCode = 31 * hashCode + (this.getOwningAccount() == null ? 0 : this.getOwningAccount().hashCode());
        return hashCode;
    }

    @Override
    public ListMetricsRequest clone() {
        return (ListMetricsRequest)super.clone();
    }
}

