/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.serialization.SerializationSchema;
import org.apache.flink.api.connector.sink2.Sink;
import org.apache.flink.connector.base.sink.AsyncSinkBase;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSink;
import org.apache.flink.connector.base.table.sink.AsyncDynamicTableSinkBuilder;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSink;
import org.apache.flink.connector.kinesis.sink.KinesisStreamsSinkBuilder;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.connector.kinesis.table.RowDataFieldsKinesisPartitionKeyGenerator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.PutRecordsRequestEntry;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.format.EncodingFormat;
import org.apache.flink.table.connector.sink.DynamicTableSink;
import org.apache.flink.table.connector.sink.SinkV2Provider;
import org.apache.flink.table.connector.sink.abilities.SupportsPartitioning;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.types.DataType;
import org.apache.flink.util.Preconditions;

@Internal
public class KinesisDynamicSink
extends AsyncDynamicTableSink<PutRecordsRequestEntry>
implements SupportsPartitioning {
    private final DataType consumedDataType;
    private final String stream;
    private final Properties kinesisClientProperties;
    private final EncodingFormat<SerializationSchema<RowData>> encodingFormat;
    private final PartitionKeyGenerator<RowData> partitioner;
    private final Boolean failOnError;

    public KinesisDynamicSink(@Nullable Integer maxBatchSize, @Nullable Integer maxInFlightRequests, @Nullable Integer maxBufferedRequests, @Nullable Long maxBufferSizeInBytes, @Nullable Long maxTimeInBufferMS, @Nullable Boolean failOnError, @Nullable DataType consumedDataType, String stream, @Nullable Properties kinesisClientProperties, EncodingFormat<SerializationSchema<RowData>> encodingFormat, PartitionKeyGenerator<RowData> partitioner) {
        super(maxBatchSize, maxInFlightRequests, maxBufferedRequests, maxBufferSizeInBytes, maxTimeInBufferMS);
        this.failOnError = failOnError;
        this.kinesisClientProperties = kinesisClientProperties;
        this.consumedDataType = (DataType)Preconditions.checkNotNull((Object)consumedDataType, (String)"Consumed data type must not be null");
        this.stream = (String)Preconditions.checkNotNull((Object)stream, (String)"Kinesis stream name must not be null");
        this.encodingFormat = (EncodingFormat)Preconditions.checkNotNull(encodingFormat, (String)"Encoding format must not be null");
        this.partitioner = (PartitionKeyGenerator)Preconditions.checkNotNull(partitioner, (String)"Kinesis partition key generator must not be null");
    }

    public ChangelogMode getChangelogMode(ChangelogMode requestedMode) {
        return this.encodingFormat.getChangelogMode();
    }

    public DynamicTableSink.SinkRuntimeProvider getSinkRuntimeProvider(DynamicTableSink.Context context) {
        SerializationSchema serializationSchema = (SerializationSchema)this.encodingFormat.createRuntimeEncoder(context, this.consumedDataType);
        KinesisStreamsSinkBuilder<RowData> builder = KinesisStreamsSink.builder().setSerializationSchema(serializationSchema).setPartitionKeyGenerator(this.partitioner).setKinesisClientProperties(this.kinesisClientProperties).setStreamName(this.stream);
        Optional.ofNullable(this.failOnError).ifPresent(builder::setFailOnError);
        this.addAsyncOptionsToSinkBuilder(builder);
        AsyncSinkBase kdsSink = builder.build();
        return SinkV2Provider.of((Sink)kdsSink);
    }

    public DynamicTableSink copy() {
        return new KinesisDynamicSink(this.maxBatchSize, this.maxInFlightRequests, this.maxBufferedRequests, this.maxBufferSizeInBytes, this.maxTimeInBufferMS, this.failOnError, this.consumedDataType, this.stream, this.kinesisClientProperties, this.encodingFormat, this.partitioner);
    }

    public String asSummaryString() {
        return "Kinesis";
    }

    public void applyStaticPartition(Map<String, String> partition) {
        if (!(this.partitioner instanceof RowDataFieldsKinesisPartitionKeyGenerator)) {
            String msg = "Cannot apply static partition optimization to a partition class that does not inherit from org.apache.flink.streaming.connectors.kinesis.table.RowDataKinesisPartitioner.";
            throw new RuntimeException(msg);
        }
        ((RowDataFieldsKinesisPartitionKeyGenerator)this.partitioner).setStaticFields(partition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KinesisDynamicSink that = (KinesisDynamicSink)((Object)o);
        return super.equals(o) && Objects.equals(this.consumedDataType, that.consumedDataType) && Objects.equals(this.stream, that.stream) && Objects.equals(this.kinesisClientProperties, that.kinesisClientProperties) && Objects.equals(this.encodingFormat, that.encodingFormat) && Objects.equals(this.partitioner, that.partitioner) && Objects.equals(this.failOnError, that.failOnError);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.consumedDataType, this.stream, this.kinesisClientProperties, this.encodingFormat, this.partitioner, this.failOnError);
    }

    @Internal
    public static class KinesisDynamicTableSinkBuilder
    extends AsyncDynamicTableSinkBuilder<PutRecordsRequestEntry, KinesisDynamicTableSinkBuilder> {
        private DataType consumedDataType = null;
        private String stream = null;
        private Properties kinesisClientProperties = null;
        private EncodingFormat<SerializationSchema<RowData>> encodingFormat = null;
        private PartitionKeyGenerator<RowData> partitioner = null;
        private Boolean failOnError = null;

        public KinesisDynamicTableSinkBuilder setConsumedDataType(DataType consumedDataType) {
            this.consumedDataType = consumedDataType;
            return this;
        }

        public KinesisDynamicTableSinkBuilder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        public KinesisDynamicTableSinkBuilder setKinesisClientProperties(Properties kinesisClientProperties) {
            this.kinesisClientProperties = kinesisClientProperties;
            return this;
        }

        public KinesisDynamicTableSinkBuilder setEncodingFormat(EncodingFormat<SerializationSchema<RowData>> encodingFormat) {
            this.encodingFormat = encodingFormat;
            return this;
        }

        public KinesisDynamicTableSinkBuilder setFailOnError(Boolean failOnError) {
            this.failOnError = failOnError;
            return this;
        }

        public KinesisDynamicTableSinkBuilder setPartitioner(PartitionKeyGenerator<RowData> partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public KinesisDynamicSink build() {
            return new KinesisDynamicSink(this.getMaxBatchSize(), this.getMaxInFlightRequests(), this.getMaxBufferedRequests(), this.getMaxBufferSizeInBytes(), this.getMaxTimeInBufferMS(), this.failOnError, this.consumedDataType, this.stream, this.kinesisClientProperties, this.encodingFormat, this.partitioner);
        }
    }
}

