/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.source.reader;

import org.apache.flink.annotation.Internal;
import org.apache.flink.api.connector.source.SourceOutput;
import org.apache.flink.connector.base.source.reader.RecordEmitter;
import org.apache.flink.connector.kinesis.source.serialization.KinesisDeserializationSchema;
import org.apache.flink.connector.kinesis.source.split.KinesisShardSplitState;
import org.apache.flink.connector.kinesis.source.split.StartingPosition;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.Record;
import org.apache.flink.util.Collector;

@Internal
public class KinesisStreamsRecordEmitter<T>
implements RecordEmitter<Record, T, KinesisShardSplitState> {
    private final KinesisDeserializationSchema<T> deserializationSchema;
    private final SourceOutputWrapper<T> sourceOutputWrapper = new SourceOutputWrapper();

    public KinesisStreamsRecordEmitter(KinesisDeserializationSchema<T> deserializationSchema) {
        this.deserializationSchema = deserializationSchema;
    }

    public void emitRecord(Record element, SourceOutput<T> output, KinesisShardSplitState splitState) throws Exception {
        ((SourceOutputWrapper)this.sourceOutputWrapper).setSourceOutput(output);
        ((SourceOutputWrapper)this.sourceOutputWrapper).setTimestamp(element.approximateArrivalTimestamp().toEpochMilli());
        this.deserializationSchema.deserialize(element, splitState.getStreamArn(), splitState.getShardId(), this.sourceOutputWrapper);
        splitState.setNextStartingPosition(StartingPosition.continueFromSequenceNumber(element.sequenceNumber()));
    }

    private static class SourceOutputWrapper<T>
    implements Collector<T> {
        private SourceOutput<T> sourceOutput;
        private long timestamp;

        private SourceOutputWrapper() {
        }

        public void collect(T record) {
            this.sourceOutput.collect(record, this.timestamp);
        }

        public void close() {
        }

        private void setSourceOutput(SourceOutput<T> sourceOutput) {
            this.sourceOutput = sourceOutput;
        }

        private void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

