/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.aws.table.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.base.table.options.ConfigurationValidator;
import org.apache.flink.connector.base.table.options.TableOptionsUtils;
import org.apache.flink.connector.base.table.util.ConfigurationValidatorUtil;
import org.apache.flink.kinesis.shaded.org.apache.flink.connector.aws.util.AWSGeneralUtil;

@PublicEvolving
public class AWSOptionUtils
implements TableOptionsUtils,
ConfigurationValidator {
    public static final String AWS_PROPERTIES_PREFIX = "aws.";
    private final Map<String, String> resolvedOptions;

    public AWSOptionUtils(Map<String, String> resolvedOptions) {
        this.resolvedOptions = resolvedOptions;
    }

    public Map<String, String> getProcessedResolvedOptions() {
        HashMap<String, String> mappedResolvedOptions = new HashMap<String, String>();
        for (String key : this.resolvedOptions.keySet()) {
            if (!key.startsWith(AWS_PROPERTIES_PREFIX)) continue;
            mappedResolvedOptions.put(AWSOptionUtils.translateAwsKey(key), this.resolvedOptions.get(key));
        }
        return mappedResolvedOptions;
    }

    public List<String> getNonValidatedPrefixes() {
        return Collections.singletonList(AWS_PROPERTIES_PREFIX);
    }

    public Properties getValidatedConfigurations() {
        Properties awsConfigurations = new Properties();
        Map<String, String> mappedProperties = this.getProcessedResolvedOptions();
        for (Map.Entry<String, String> entry : mappedProperties.entrySet()) {
            awsConfigurations.setProperty(entry.getKey(), entry.getValue());
        }
        AWSGeneralUtil.validateAwsConfiguration(awsConfigurations);
        ConfigurationValidatorUtil.validateOptionalBooleanProperty((Properties)awsConfigurations, (String)"aws.trust.all.certificates", (String)String.format("Invalid %s value, must be a boolean.", "aws.trust.all.certificates"));
        return awsConfigurations;
    }

    private static String translateAwsKey(String key) {
        if (!key.endsWith("credentials.provider")) {
            return key.replace("credentials.", "credentials.provider.");
        }
        return key;
    }
}

