/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.math.BigInteger;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.HashKeyRange;
import org.apache.flink.streaming.connectors.kinesis.KinesisShardAssigner;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;

@PublicEvolving
public class UniformShardAssigner
implements KinesisShardAssigner {
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger HASH_KEY_BOUND = TWO.pow(128);

    @Override
    public int assign(StreamShardHandle streamShardHandle, int nSubtasks) {
        HashKeyRange range = streamShardHandle.getShard().getHashKeyRange();
        BigInteger hashKeyStart = new BigInteger(range.getStartingHashKey());
        BigInteger hashKeyEnd = new BigInteger(range.getEndingHashKey());
        BigInteger hashKeyMid = hashKeyStart.add(hashKeyEnd).divide(TWO);
        return hashKeyMid.multiply(BigInteger.valueOf(nSubtasks)).divide(HASH_KEY_BOUND).intValue() + streamShardHandle.getStreamName().hashCode();
    }
}

