/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.internals.publisher;

import java.math.BigInteger;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.UserRecord;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Record;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;
import org.apache.flink.util.Preconditions;

@Internal
public class RecordBatch {
    private final int aggregatedRecordSize;
    private final List<UserRecord> deaggregatedRecords;
    private final long totalSizeInBytes;
    private final Long millisBehindLatest;

    public RecordBatch(List<Record> records, StreamShardHandle subscribedShard, @Nullable Long millisBehindLatest) {
        Preconditions.checkNotNull((Object)subscribedShard);
        this.aggregatedRecordSize = ((List)Preconditions.checkNotNull(records)).size();
        this.deaggregatedRecords = this.deaggregateRecords(records, subscribedShard);
        this.totalSizeInBytes = this.deaggregatedRecords.stream().mapToInt(r -> r.getData().remaining()).sum();
        this.millisBehindLatest = millisBehindLatest;
    }

    public int getAggregatedRecordSize() {
        return this.aggregatedRecordSize;
    }

    public int getDeaggregatedRecordSize() {
        return this.deaggregatedRecords.size();
    }

    public List<UserRecord> getDeaggregatedRecords() {
        return this.deaggregatedRecords;
    }

    public long getTotalSizeInBytes() {
        return this.totalSizeInBytes;
    }

    public long getAverageRecordSizeBytes() {
        return this.deaggregatedRecords.isEmpty() ? 0L : this.getTotalSizeInBytes() / (long)this.getDeaggregatedRecordSize();
    }

    @Nullable
    public Long getMillisBehindLatest() {
        return this.millisBehindLatest;
    }

    private List<UserRecord> deaggregateRecords(List<Record> records, StreamShardHandle subscribedShard) {
        BigInteger start = new BigInteger(subscribedShard.getShard().getHashKeyRange().getStartingHashKey());
        BigInteger end = new BigInteger(subscribedShard.getShard().getHashKeyRange().getEndingHashKey());
        return UserRecord.deaggregate(records, start, end);
    }
}

