/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.paginators;

import java.util.Iterator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.SdkIterable;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.util.PaginatorUtils;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisClient;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.ListStreamConsumersResponse;

public class ListStreamConsumersIterable
implements SdkIterable<ListStreamConsumersResponse> {
    private final KinesisClient client;
    private final ListStreamConsumersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListStreamConsumersIterable(KinesisClient client, ListStreamConsumersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListStreamConsumersResponseFetcher();
    }

    @Override
    public Iterator<ListStreamConsumersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListStreamConsumersResponseFetcher
    implements SyncPageFetcher<ListStreamConsumersResponse> {
        private ListStreamConsumersResponseFetcher() {
        }

        @Override
        public boolean hasNextPage(ListStreamConsumersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable(previousPage.nextToken());
        }

        @Override
        public ListStreamConsumersResponse nextPage(ListStreamConsumersResponse previousPage) {
            if (previousPage == null) {
                return ListStreamConsumersIterable.this.client.listStreamConsumers(ListStreamConsumersIterable.this.firstRequest);
            }
            return ListStreamConsumersIterable.this.client.listStreamConsumers((ListStreamConsumersRequest)ListStreamConsumersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build());
        }
    }
}

