/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkField;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.SdkPojo;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.traits.LocationTrait;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.HashKeyRange;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.model.SequenceNumberRange;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.ToString;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.CopyableBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Shard
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Shard> {
    private static final SdkField<String> SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ShardId").getter(Shard.getter(Shard::shardId)).setter(Shard.setter(Builder::shardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardId").build()).build();
    private static final SdkField<String> PARENT_SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("ParentShardId").getter(Shard.getter(Shard::parentShardId)).setter(Shard.setter(Builder::parentShardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentShardId").build()).build();
    private static final SdkField<String> ADJACENT_PARENT_SHARD_ID_FIELD = SdkField.builder(MarshallingType.STRING).memberName("AdjacentParentShardId").getter(Shard.getter(Shard::adjacentParentShardId)).setter(Shard.setter(Builder::adjacentParentShardId)).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdjacentParentShardId").build()).build();
    private static final SdkField<HashKeyRange> HASH_KEY_RANGE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("HashKeyRange").getter(Shard.getter(Shard::hashKeyRange)).setter(Shard.setter(Builder::hashKeyRange)).constructor(HashKeyRange::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HashKeyRange").build()).build();
    private static final SdkField<SequenceNumberRange> SEQUENCE_NUMBER_RANGE_FIELD = SdkField.builder(MarshallingType.SDK_POJO).memberName("SequenceNumberRange").getter(Shard.getter(Shard::sequenceNumberRange)).setter(Shard.setter(Builder::sequenceNumberRange)).constructor(SequenceNumberRange::builder).traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SequenceNumberRange").build()).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARD_ID_FIELD, PARENT_SHARD_ID_FIELD, ADJACENT_PARENT_SHARD_ID_FIELD, HASH_KEY_RANGE_FIELD, SEQUENCE_NUMBER_RANGE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String shardId;
    private final String parentShardId;
    private final String adjacentParentShardId;
    private final HashKeyRange hashKeyRange;
    private final SequenceNumberRange sequenceNumberRange;

    private Shard(BuilderImpl builder) {
        this.shardId = builder.shardId;
        this.parentShardId = builder.parentShardId;
        this.adjacentParentShardId = builder.adjacentParentShardId;
        this.hashKeyRange = builder.hashKeyRange;
        this.sequenceNumberRange = builder.sequenceNumberRange;
    }

    public final String shardId() {
        return this.shardId;
    }

    public final String parentShardId() {
        return this.parentShardId;
    }

    public final String adjacentParentShardId() {
        return this.adjacentParentShardId;
    }

    public final HashKeyRange hashKeyRange() {
        return this.hashKeyRange;
    }

    public final SequenceNumberRange sequenceNumberRange() {
        return this.sequenceNumberRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.shardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.adjacentParentShardId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hashKeyRange());
        hashCode = 31 * hashCode + Objects.hashCode(this.sequenceNumberRange());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Shard)) {
            return false;
        }
        Shard other = (Shard)obj;
        return Objects.equals(this.shardId(), other.shardId()) && Objects.equals(this.parentShardId(), other.parentShardId()) && Objects.equals(this.adjacentParentShardId(), other.adjacentParentShardId()) && Objects.equals(this.hashKeyRange(), other.hashKeyRange()) && Objects.equals(this.sequenceNumberRange(), other.sequenceNumberRange());
    }

    public final String toString() {
        return ToString.builder("Shard").add("ShardId", this.shardId()).add("ParentShardId", this.parentShardId()).add("AdjacentParentShardId", this.adjacentParentShardId()).add("HashKeyRange", this.hashKeyRange()).add("SequenceNumberRange", this.sequenceNumberRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ShardId": {
                return Optional.ofNullable(clazz.cast(this.shardId()));
            }
            case "ParentShardId": {
                return Optional.ofNullable(clazz.cast(this.parentShardId()));
            }
            case "AdjacentParentShardId": {
                return Optional.ofNullable(clazz.cast(this.adjacentParentShardId()));
            }
            case "HashKeyRange": {
                return Optional.ofNullable(clazz.cast(this.hashKeyRange()));
            }
            case "SequenceNumberRange": {
                return Optional.ofNullable(clazz.cast(this.sequenceNumberRange()));
            }
        }
        return Optional.empty();
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Shard, T> g) {
        return obj -> g.apply((Shard)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String shardId;
        private String parentShardId;
        private String adjacentParentShardId;
        private HashKeyRange hashKeyRange;
        private SequenceNumberRange sequenceNumberRange;

        private BuilderImpl() {
        }

        private BuilderImpl(Shard model) {
            this.shardId(model.shardId);
            this.parentShardId(model.parentShardId);
            this.adjacentParentShardId(model.adjacentParentShardId);
            this.hashKeyRange(model.hashKeyRange);
            this.sequenceNumberRange(model.sequenceNumberRange);
        }

        public final String getShardId() {
            return this.shardId;
        }

        public final void setShardId(String shardId) {
            this.shardId = shardId;
        }

        @Override
        public final Builder shardId(String shardId) {
            this.shardId = shardId;
            return this;
        }

        public final String getParentShardId() {
            return this.parentShardId;
        }

        public final void setParentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
        }

        @Override
        public final Builder parentShardId(String parentShardId) {
            this.parentShardId = parentShardId;
            return this;
        }

        public final String getAdjacentParentShardId() {
            return this.adjacentParentShardId;
        }

        public final void setAdjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
        }

        @Override
        public final Builder adjacentParentShardId(String adjacentParentShardId) {
            this.adjacentParentShardId = adjacentParentShardId;
            return this;
        }

        public final HashKeyRange.Builder getHashKeyRange() {
            return this.hashKeyRange != null ? this.hashKeyRange.toBuilder() : null;
        }

        public final void setHashKeyRange(HashKeyRange.BuilderImpl hashKeyRange) {
            this.hashKeyRange = hashKeyRange != null ? hashKeyRange.build() : null;
        }

        @Override
        public final Builder hashKeyRange(HashKeyRange hashKeyRange) {
            this.hashKeyRange = hashKeyRange;
            return this;
        }

        public final SequenceNumberRange.Builder getSequenceNumberRange() {
            return this.sequenceNumberRange != null ? this.sequenceNumberRange.toBuilder() : null;
        }

        public final void setSequenceNumberRange(SequenceNumberRange.BuilderImpl sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange != null ? sequenceNumberRange.build() : null;
        }

        @Override
        public final Builder sequenceNumberRange(SequenceNumberRange sequenceNumberRange) {
            this.sequenceNumberRange = sequenceNumberRange;
            return this;
        }

        @Override
        public Shard build() {
            return new Shard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Shard> {
        public Builder shardId(String var1);

        public Builder parentShardId(String var1);

        public Builder adjacentParentShardId(String var1);

        public Builder hashKeyRange(HashKeyRange var1);

        default public Builder hashKeyRange(Consumer<HashKeyRange.Builder> hashKeyRange) {
            return this.hashKeyRange((HashKeyRange)HashKeyRange.builder().applyMutation(hashKeyRange).build());
        }

        public Builder sequenceNumberRange(SequenceNumberRange var1);

        default public Builder sequenceNumberRange(Consumer<SequenceNumberRange.Builder> sequenceNumberRange) {
            return this.sequenceNumberRange((SequenceNumberRange)SequenceNumberRange.builder().applyMutation(sequenceNumberRange).build());
        }
    }
}

