/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis;

import java.util.List;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.auth.signer.Aws4Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.client.config.SdkClientOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ClasspathInterceptorChainFactory;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.signer.Signer;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.Protocol;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpConfigurationOption;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisBaseClientBuilder;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.KinesisRetryPolicy;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.services.kinesis.internal.KinesisHttpConfigurationOptions;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.AttributeMap;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
abstract class DefaultKinesisBaseClientBuilder<B extends KinesisBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultKinesisBaseClientBuilder() {
    }

    @Override
    protected final String serviceEndpointPrefix() {
        return "kinesis";
    }

    @Override
    protected final String serviceName() {
        return "Kinesis";
    }

    @Override
    protected final SdkClientConfiguration mergeServiceDefaults(SdkClientConfiguration config) {
        return config.merge(c -> c.option(SdkAdvancedClientOption.SIGNER, this.defaultSigner()).option(SdkClientOption.CRC32_FROM_COMPRESSED_DATA_ENABLED, false));
    }

    @Override
    protected final SdkClientConfiguration finalizeServiceConfiguration(SdkClientConfiguration config) {
        ClasspathInterceptorChainFactory interceptorFactory = new ClasspathInterceptorChainFactory();
        List<ExecutionInterceptor> interceptors = interceptorFactory.getInterceptors("org/apache/flink/kinesis/shaded/software/amazon/awssdk/services/kinesis/execution.interceptors");
        interceptors = CollectionUtils.mergeLists(interceptors, config.option(SdkClientOption.EXECUTION_INTERCEPTORS));
        return config.toBuilder().option(SdkClientOption.EXECUTION_INTERCEPTORS, interceptors).option(SdkClientOption.RETRY_POLICY, KinesisRetryPolicy.resolveRetryPolicy(config)).build();
    }

    private Signer defaultSigner() {
        return Aws4Signer.create();
    }

    @Override
    protected final String signingName() {
        return "kinesis";
    }

    @Override
    protected final AttributeMap serviceHttpConfig() {
        AttributeMap result = KinesisHttpConfigurationOptions.defaultHttpConfig();
        return result.merge(AttributeMap.builder().put(SdkHttpConfigurationOption.PROTOCOL, Protocol.HTTP2).build());
    }
}

