/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal;

import java.util.concurrent.TimeUnit;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelDuplexHandler;
import org.apache.flink.kinesis.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.flink.kinesis.shaded.io.netty.util.concurrent.ScheduledFuture;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.ChannelAttributeKey;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.nio.netty.internal.utils.NettyClientLogger;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class OldConnectionReaperHandler
extends ChannelDuplexHandler {
    private static final NettyClientLogger log = NettyClientLogger.getLogger(OldConnectionReaperHandler.class);
    private final int connectionTtlMillis;
    private ScheduledFuture<?> channelKiller;

    public OldConnectionReaperHandler(int connectionTtlMillis) {
        Validate.isPositive(connectionTtlMillis, "connectionTtlMillis");
        this.connectionTtlMillis = connectionTtlMillis;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.handlerAdded(ctx);
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelRegistered(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (this.channelKiller == null) {
            this.channelKiller = ctx.channel().eventLoop().schedule(() -> this.closeChannel(ctx), (long)this.connectionTtlMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.destroy();
    }

    private void destroy() {
        if (this.channelKiller != null) {
            this.channelKiller.cancel(false);
            this.channelKiller = null;
        }
    }

    private void closeChannel(ChannelHandlerContext ctx) {
        assert (ctx.channel().eventLoop().inEventLoop());
        if (ctx.channel().isOpen()) {
            if (Boolean.FALSE.equals(ctx.channel().attr(ChannelAttributeKey.IN_USE).get())) {
                log.debug(ctx.channel(), () -> "Closing unused connection (" + ctx.channel().id() + ") because it has reached its maximum time to live of " + this.connectionTtlMillis + " milliseconds.");
                ctx.close();
            } else {
                log.debug(ctx.channel(), () -> "Connection (" + ctx.channel().id() + ") will be closed during its next release, because it has reached its maximum time to live of " + this.connectionTtlMillis + " milliseconds.");
                ctx.channel().attr(ChannelAttributeKey.CLOSE_ON_RELEASE).set(true);
            }
        }
        this.channelKiller = null;
    }
}

