/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.stages;

import org.apache.flink.kinesis.shaded.software.amazon.awssdk.annotations.SdkInternalApi;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.interceptor.InterceptorContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.InterruptMonitor;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.RequestExecutionContext;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.core.internal.http.pipeline.RequestPipeline;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.AbortableInputStream;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullRequest;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpFullResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.http.SdkHttpResponse;
import org.apache.flink.kinesis.shaded.software.amazon.awssdk.utils.Pair;

@SdkInternalApi
public class AfterTransmissionExecutionInterceptorsStage
implements RequestPipeline<Pair<SdkHttpFullRequest, SdkHttpFullResponse>, Pair<SdkHttpFullRequest, SdkHttpFullResponse>> {
    @Override
    public Pair<SdkHttpFullRequest, SdkHttpFullResponse> execute(Pair<SdkHttpFullRequest, SdkHttpFullResponse> input, RequestExecutionContext context) throws Exception {
        InterruptMonitor.checkInterrupted();
        InterceptorContext interceptorContext = (InterceptorContext)context.executionContext().interceptorContext().copy(b -> b.httpResponse((SdkHttpResponse)input.right()).responseBody(((SdkHttpFullResponse)input.right()).content().orElse(null)));
        context.interceptorChain().afterTransmission(interceptorContext, context.executionAttributes());
        interceptorContext = context.interceptorChain().modifyHttpResponse(interceptorContext, context.executionAttributes());
        context.executionContext().interceptorContext(interceptorContext);
        InterruptMonitor.checkInterrupted((SdkHttpFullResponse)interceptorContext.httpResponse());
        SdkHttpFullResponse response = (SdkHttpFullResponse)interceptorContext.httpResponse();
        if (interceptorContext.responseBody().isPresent()) {
            response = response.toBuilder().content(AbortableInputStream.create(interceptorContext.responseBody().get())).build();
        }
        return Pair.of(input.left(), response);
    }
}

