/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.StructuredPojo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.Processor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesisfirehose.model.transform.ProcessingConfigurationMarshaller;

public class ProcessingConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Boolean enabled;
    private List<Processor> processors;

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ProcessingConfiguration withEnabled(Boolean enabled) {
        this.setEnabled(enabled);
        return this;
    }

    public Boolean isEnabled() {
        return this.enabled;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Collection<Processor> processors) {
        if (processors == null) {
            this.processors = null;
            return;
        }
        this.processors = new ArrayList<Processor>(processors);
    }

    public ProcessingConfiguration withProcessors(Processor ... processors) {
        if (this.processors == null) {
            this.setProcessors(new ArrayList<Processor>(processors.length));
        }
        for (Processor ele : processors) {
            this.processors.add(ele);
        }
        return this;
    }

    public ProcessingConfiguration withProcessors(Collection<Processor> processors) {
        this.setProcessors(processors);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getEnabled() != null) {
            sb.append("Enabled: ").append(this.getEnabled()).append(",");
        }
        if (this.getProcessors() != null) {
            sb.append("Processors: ").append(this.getProcessors());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProcessingConfiguration)) {
            return false;
        }
        ProcessingConfiguration other = (ProcessingConfiguration)obj;
        if (other.getEnabled() == null ^ this.getEnabled() == null) {
            return false;
        }
        if (other.getEnabled() != null && !other.getEnabled().equals(this.getEnabled())) {
            return false;
        }
        if (other.getProcessors() == null ^ this.getProcessors() == null) {
            return false;
        }
        return other.getProcessors() == null || other.getProcessors().equals(this.getProcessors());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getEnabled() == null ? 0 : this.getEnabled().hashCode());
        hashCode = 31 * hashCode + (this.getProcessors() == null ? 0 : this.getProcessors().hashCode());
        return hashCode;
    }

    public ProcessingConfiguration clone() {
        try {
            return (ProcessingConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ProcessingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

