/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisShardSyncer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.LeaseSynchronizer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.Log;
import org.apache.flink.kinesis.shaded.org.apache.commons.logging.LogFactory;

class EmptyLeaseTableSynchronizer
implements LeaseSynchronizer {
    private static final Log LOG = LogFactory.getLog(EmptyLeaseTableSynchronizer.class);

    @Override
    public List<KinesisClientLease> determineNewLeasesToCreate(List<Shard> shards, List<KinesisClientLease> currentLeases, InitialPositionInStreamExtended initialPosition, Set<String> inconsistentShardIds) {
        Map<String, Shard> shardIdToShardMapOfAllKinesisShards = KinesisShardSyncer.constructShardIdToShardMap(shards);
        currentLeases.forEach(lease -> LOG.debug("Existing lease: " + lease.getLeaseKey()));
        List<KinesisClientLease> newLeasesToCreate = this.getLeasesToCreateForOpenAndClosedShards(initialPosition, shards);
        KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator startingSequenceNumberComparator = new KinesisShardSyncer.StartingSequenceNumberAndShardIdBasedComparator(shardIdToShardMapOfAllKinesisShards);
        newLeasesToCreate.sort(startingSequenceNumberComparator);
        return newLeasesToCreate;
    }

    private List<KinesisClientLease> getLeasesToCreateForOpenAndClosedShards(InitialPositionInStreamExtended initialPosition, List<Shard> shards) {
        HashMap<String, KinesisClientLease> shardIdToNewLeaseMap = new HashMap<String, KinesisClientLease>();
        for (Shard shard : shards) {
            String shardId = shard.getShardId();
            KinesisClientLease lease = KinesisShardSyncer.newKCLLease(shard);
            ExtendedSequenceNumber checkpoint = KinesisShardSyncer.convertToCheckpoint(initialPosition);
            lease.setCheckpoint(checkpoint);
            LOG.debug("Need to create a lease for shard with shardId " + shardId);
            shardIdToNewLeaseMap.put(shardId, lease);
        }
        return new ArrayList<KinesisClientLease>(shardIdToNewLeaseMap.values());
    }
}

