/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.annotation.SdkInternalApi;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallLocation;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.MarshallingType;
import org.apache.flink.kinesis.shaded.com.amazonaws.protocol.ProtocolMarshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.model.Endpoint;

@SdkInternalApi
public class EndpointMarshaller {
    private static final MarshallingInfo<String> ADDRESS_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Address").build();
    private static final MarshallingInfo<Long> CACHEPERIODINMINUTES_BINDING = MarshallingInfo.builder(MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CachePeriodInMinutes").build();
    private static final EndpointMarshaller instance = new EndpointMarshaller();

    public static EndpointMarshaller getInstance() {
        return instance;
    }

    public void marshall(Endpoint endpoint, ProtocolMarshaller protocolMarshaller) {
        if (endpoint == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(endpoint.getAddress(), ADDRESS_BINDING);
            protocolMarshaller.marshall(endpoint.getCachePeriodInMinutes(), CACHEPERIODINMINUTES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

