/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kinesis.table;

import java.util.Objects;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.connector.kinesis.sink.PartitionKeyGenerator;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public final class FixedKinesisPartitionKeyGenerator<T>
implements PartitionKeyGenerator<T> {
    private static final long serialVersionUID = 1L;
    private int indexOfThisSubtask = 0;

    public void initialize(int indexOfThisSubtask, int numberOfParallelSubtasks) {
        Preconditions.checkArgument((indexOfThisSubtask >= 0 ? 1 : 0) != 0, (Object)"Id of this subtask cannot be negative.");
        Preconditions.checkArgument((numberOfParallelSubtasks > 0 ? 1 : 0) != 0, (Object)"Number of subtasks must be larger than 0.");
        this.indexOfThisSubtask = indexOfThisSubtask;
    }

    @Override
    public String apply(T record) {
        return String.valueOf(this.indexOfThisSubtask);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FixedKinesisPartitionKeyGenerator that = (FixedKinesisPartitionKeyGenerator)o;
        return Objects.equals(this.indexOfThisSubtask, that.indexOfThisSubtask);
    }

    public int hashCode() {
        return Objects.hash(FixedKinesisPartitionKeyGenerator.class.hashCode(), this.indexOfThisSubtask);
    }
}

