/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.util.serialization;

import java.io.IOException;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.api.java.typeutils.TypeExtractor;
import org.apache.flink.core.memory.DataInputDeserializer;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputSerializer;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.streaming.util.serialization.KeyedSerializationSchema;

@Deprecated
@PublicEvolving
public class TypeInformationKeyValueSerializationSchema<K, V>
implements KafkaDeserializationSchema<Tuple2<K, V>>,
KeyedSerializationSchema<Tuple2<K, V>> {
    private static final long serialVersionUID = -5359448468131559102L;
    private final TypeSerializer<K> keySerializer;
    private final TypeSerializer<V> valueSerializer;
    private final DataInputDeserializer inputDeserializer;
    private transient DataOutputSerializer keyOutputSerializer;
    private transient DataOutputSerializer valueOutputSerializer;
    private final transient TypeInformation<Tuple2<K, V>> typeInfo;

    public TypeInformationKeyValueSerializationSchema(TypeInformation<K> keyTypeInfo, TypeInformation<V> valueTypeInfo, ExecutionConfig ec) {
        this.typeInfo = new TupleTypeInfo(new TypeInformation[]{keyTypeInfo, valueTypeInfo});
        this.keySerializer = keyTypeInfo.createSerializer(ec);
        this.valueSerializer = valueTypeInfo.createSerializer(ec);
        this.inputDeserializer = new DataInputDeserializer();
    }

    public TypeInformationKeyValueSerializationSchema(Class<K> keyClass, Class<V> valueClass, ExecutionConfig config) {
        this(TypeExtractor.createTypeInfo(keyClass), TypeExtractor.createTypeInfo(valueClass), config);
    }

    @Override
    public Tuple2<K, V> deserialize(ConsumerRecord<byte[], byte[]> record) throws Exception {
        Object key = null;
        Object value = null;
        if (record.key() != null) {
            this.inputDeserializer.setBuffer(record.key());
            key = this.keySerializer.deserialize((DataInputView)this.inputDeserializer);
        }
        if (record.value() != null) {
            this.inputDeserializer.setBuffer(record.value());
            value = this.valueSerializer.deserialize((DataInputView)this.inputDeserializer);
        }
        return new Tuple2(key, value);
    }

    @Override
    public boolean isEndOfStream(Tuple2<K, V> nextElement) {
        return false;
    }

    @Override
    public byte[] serializeKey(Tuple2<K, V> element) {
        if (element.f0 == null) {
            return null;
        }
        if (this.keyOutputSerializer == null) {
            this.keyOutputSerializer = new DataOutputSerializer(16);
        }
        try {
            this.keySerializer.serialize(element.f0, (DataOutputView)this.keyOutputSerializer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize record", e);
        }
        byte[] res = this.keyOutputSerializer.getByteArray();
        if (res.length != this.keyOutputSerializer.length()) {
            byte[] n = new byte[this.keyOutputSerializer.length()];
            System.arraycopy(res, 0, n, 0, this.keyOutputSerializer.length());
            res = n;
        }
        this.keyOutputSerializer.clear();
        return res;
    }

    @Override
    public byte[] serializeValue(Tuple2<K, V> element) {
        if (element.f1 == null) {
            return null;
        }
        if (this.valueOutputSerializer == null) {
            this.valueOutputSerializer = new DataOutputSerializer(16);
        }
        try {
            this.valueSerializer.serialize(element.f1, (DataOutputView)this.valueOutputSerializer);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to serialize record", e);
        }
        byte[] res = this.valueOutputSerializer.getByteArray();
        if (res.length != this.valueOutputSerializer.length()) {
            byte[] n = new byte[this.valueOutputSerializer.length()];
            System.arraycopy(res, 0, n, 0, this.valueOutputSerializer.length());
            res = n;
        }
        this.valueOutputSerializer.clear();
        return res;
    }

    @Override
    public String getTargetTopic(Tuple2<K, V> element) {
        return null;
    }

    public TypeInformation<Tuple2<K, V>> getProducedType() {
        if (this.typeInfo != null) {
            return this.typeInfo;
        }
        throw new IllegalStateException("The type information is not available after this class has been serialized and distributed.");
    }
}

