/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.kafka.source.reader.deserializer;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaDeserializationSchemaWrapper;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaValueOnlyDeserializationSchemaWrapper;
import org.apache.flink.connector.kafka.source.reader.deserializer.KafkaValueOnlyDeserializerWrapper;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.serialization.Deserializer;
import org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import org.apache.flink.util.Collector;

@PublicEvolving
public interface KafkaRecordDeserializationSchema<T>
extends Serializable,
ResultTypeQueryable<T> {
    default public void open(DeserializationSchema.InitializationContext context) throws Exception {
    }

    public void deserialize(ConsumerRecord<byte[], byte[]> var1, Collector<T> var2) throws IOException;

    @Deprecated
    public static <V> KafkaRecordDeserializationSchema<V> of(KafkaDeserializationSchema<V> kafkaDeserializationSchema) {
        return new KafkaDeserializationSchemaWrapper<V>(kafkaDeserializationSchema);
    }

    public static <V> KafkaRecordDeserializationSchema<V> valueOnly(DeserializationSchema<V> valueDeserializationSchema) {
        return new KafkaValueOnlyDeserializationSchemaWrapper<V>(valueDeserializationSchema);
    }

    public static <V> KafkaRecordDeserializationSchema<V> valueOnly(Class<? extends Deserializer<V>> valueDeserializerClass) {
        return KafkaRecordDeserializationSchema.valueOnly(valueDeserializerClass, Collections.emptyMap());
    }

    public static <V, D extends Deserializer<V>> KafkaRecordDeserializationSchema<V> valueOnly(Class<D> valueDeserializerClass, Map<String, String> config) {
        return new KafkaValueOnlyDeserializerWrapper(valueDeserializerClass, config);
    }
}

