/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ApiMessage;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Message;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Readable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.Writable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Field;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Schema;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.types.Type;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.ByteUtils;

public class LeaveGroupResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<MemberResponse> members;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 5;

    public LeaveGroupResponseData(Readable _readable, short _version) {
        this.read(_readable, _version);
    }

    public LeaveGroupResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.members = new ArrayList<MemberResponse>(0);
    }

    @Override
    public short apiKey() {
        return 13;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 5;
    }

    @Override
    public void read(Readable _readable, short _version) {
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _readable.readShort();
        if (_version >= 3) {
            int i;
            ArrayList<MemberResponse> newCollection;
            int arrayLength;
            if (_version >= 4) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberResponse(_readable, _version));
                }
                this.members = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field members was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<MemberResponse>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new MemberResponse(_readable, _version));
                }
                this.members = newCollection;
            }
        } else {
            this.members = new ArrayList<MemberResponse>(0);
        }
        this._unknownTaggedFields = null;
        if (_version >= 4) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        _writable.writeShort(this.errorCode);
        if (_version >= 3) {
            if (_version >= 4) {
                _writable.writeUnsignedVarint(this.members.size() + 1);
                for (MemberResponse membersElement : this.members) {
                    membersElement.write(_writable, _cache, _version);
                }
            } else {
                _writable.writeInt(this.members.size());
                for (MemberResponse membersElement : this.members) {
                    membersElement.write(_writable, _cache, _version);
                }
            }
        } else if (!this.members.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default members at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 4) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(4);
        }
        _size.addBytes(2);
        if (_version >= 3) {
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.members.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (MemberResponse membersElement : this.members) {
                membersElement.addSize(_size, _cache, _version);
            }
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 4) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LeaveGroupResponseData)) {
            return false;
        }
        LeaveGroupResponseData other = (LeaveGroupResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.members == null ? other.members != null : !this.members.equals(other.members)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.members == null ? 0 : this.members.hashCode());
        return hashCode;
    }

    @Override
    public LeaveGroupResponseData duplicate() {
        LeaveGroupResponseData _duplicate = new LeaveGroupResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<MemberResponse> newMembers = new ArrayList<MemberResponse>(this.members.size());
        for (MemberResponse _element : this.members) {
            newMembers.add(_element.duplicate());
        }
        _duplicate.members = newMembers;
        return _duplicate;
    }

    public String toString() {
        return "LeaveGroupResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", members=" + MessageUtil.deepToString(this.members.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<MemberResponse> members() {
        return this.members;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public LeaveGroupResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public LeaveGroupResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public LeaveGroupResponseData setMembers(List<MemberResponse> v) {
        this.members = v;
        return this;
    }

    static {
        SCHEMA_2 = SCHEMA_1 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        SCHEMA_3 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("members", new ArrayOf(MemberResponse.SCHEMA_3), "List of leaving member responses."));
        SCHEMA_5 = SCHEMA_4 = new Schema(new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("members", new CompactArrayOf(MemberResponse.SCHEMA_4), "List of leaving member responses."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5};
    }

    public static class MemberResponse
    implements Message {
        String memberId;
        String groupInstanceId;
        short errorCode;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_3 = new Schema(new Field("member_id", Type.STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.NULLABLE_STRING, "The group instance ID to remove from the group."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."));
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 3;
        public static final short HIGHEST_SUPPORTED_VERSION = 5;

        public MemberResponse(Readable _readable, short _version) {
            this.read(_readable, _version);
        }

        public MemberResponse() {
            this.memberId = "";
            this.groupInstanceId = "";
            this.errorCode = 0;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 5;
        }

        @Override
        public void read(Readable _readable, short _version) {
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of MemberResponse");
            }
            int length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field memberId was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field memberId had invalid length " + length);
            }
            this.memberId = _readable.readString(length);
            length = _version >= 4 ? _readable.readUnsignedVarint() - 1 : (int)_readable.readShort();
            if (length < 0) {
                this.groupInstanceId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field groupInstanceId had invalid length " + length);
                }
                this.groupInstanceId = _readable.readString(length);
            }
            this.errorCode = _readable.readShort();
            this._unknownTaggedFields = null;
            if (_version >= 4) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version) {
            if (_version < 3) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of MemberResponse");
            }
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue(this.memberId);
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
            } else {
                _writable.writeShort((short)_stringBytes.length);
            }
            _writable.writeByteArray(_stringBytes);
            if (this.groupInstanceId == null) {
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                _stringBytes = _cache.getSerializedValue(this.groupInstanceId);
                if (_version >= 4) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeShort(this.errorCode);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 4) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version) {
            int _numTaggedFields = 0;
            if (_version > 5) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of MemberResponse");
            }
            byte[] _stringBytes = this.memberId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'memberId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.memberId, _stringBytes);
            if (_version >= 4) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.groupInstanceId == null) {
                if (_version >= 4) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                _stringBytes = this.groupInstanceId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'groupInstanceId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.groupInstanceId, _stringBytes);
                if (_version >= 4) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 4) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MemberResponse)) {
                return false;
            }
            MemberResponse other = (MemberResponse)obj;
            if (this.memberId == null ? other.memberId != null : !this.memberId.equals(other.memberId)) {
                return false;
            }
            if (this.groupInstanceId == null ? other.groupInstanceId != null : !this.groupInstanceId.equals(other.groupInstanceId)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.memberId == null ? 0 : this.memberId.hashCode());
            hashCode = 31 * hashCode + (this.groupInstanceId == null ? 0 : this.groupInstanceId.hashCode());
            hashCode = 31 * hashCode + this.errorCode;
            return hashCode;
        }

        @Override
        public MemberResponse duplicate() {
            MemberResponse _duplicate = new MemberResponse();
            _duplicate.memberId = this.memberId;
            _duplicate.groupInstanceId = this.groupInstanceId == null ? null : this.groupInstanceId;
            _duplicate.errorCode = this.errorCode;
            return _duplicate;
        }

        public String toString() {
            return "MemberResponse(memberId=" + (this.memberId == null ? "null" : "'" + this.memberId.toString() + "'") + ", groupInstanceId=" + (this.groupInstanceId == null ? "null" : "'" + this.groupInstanceId.toString() + "'") + ", errorCode=" + this.errorCode + ")";
        }

        public String memberId() {
            return this.memberId;
        }

        public String groupInstanceId() {
            return this.groupInstanceId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public MemberResponse setMemberId(String v) {
            this.memberId = v;
            return this;
        }

        public MemberResponse setGroupInstanceId(String v) {
            this.groupInstanceId = v;
            return this;
        }

        public MemberResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        static {
            SCHEMA_5 = SCHEMA_4 = new Schema(new Field("member_id", Type.COMPACT_STRING, "The member ID to remove from the group."), new Field("group_instance_id", Type.COMPACT_NULLABLE_STRING, "The group instance ID to remove from the group."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, SCHEMA_3, SCHEMA_4, SCHEMA_5};
        }
    }
}

