/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.clients.admin.ConsumerGroupDescription;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.KafkaFuture;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeConsumerGroupsResult {
    private final Map<String, KafkaFuture<ConsumerGroupDescription>> futures;

    public DescribeConsumerGroupsResult(Map<String, KafkaFuture<ConsumerGroupDescription>> futures) {
        this.futures = futures;
    }

    public Map<String, KafkaFuture<ConsumerGroupDescription>> describedGroups() {
        HashMap<String, KafkaFuture<ConsumerGroupDescription>> describedGroups = new HashMap<String, KafkaFuture<ConsumerGroupDescription>>();
        this.futures.forEach((key, future) -> describedGroups.put((String)key, (KafkaFuture<ConsumerGroupDescription>)future));
        return describedGroups;
    }

    public KafkaFuture<Map<String, ConsumerGroupDescription>> all() {
        return KafkaFuture.allOf(this.futures.values().toArray(new KafkaFuture[0])).thenApply(nil -> {
            HashMap descriptions = new HashMap(this.futures.size());
            this.futures.forEach((key, future) -> {
                try {
                    descriptions.put(key, future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            });
            return descriptions;
        });
    }
}

