/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured;

import java.net.URL;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.CloseableVerificationKeyResolver;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.ConfigurationUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.JaasOptionsUtils;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.JwksFileVerificationKeyResolver;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.RefreshingHttpsJwks;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.RefreshingHttpsJwksVerificationKeyResolver;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;
import org.jose4j.http.Get;
import org.jose4j.http.SimpleGet;
import org.jose4j.jwk.HttpsJwks;

public class VerificationKeyResolverFactory {
    public static CloseableVerificationKeyResolver create(Map<String, ?> configs, Map<String, Object> jaasConfig) {
        return VerificationKeyResolverFactory.create(configs, null, jaasConfig);
    }

    public static CloseableVerificationKeyResolver create(Map<String, ?> configs, String saslMechanism, Map<String, Object> jaasConfig) {
        ConfigurationUtils cu = new ConfigurationUtils(configs, saslMechanism);
        URL jwksEndpointUrl = cu.validateUrl("sasl.oauthbearer.jwks.endpoint.url");
        if (jwksEndpointUrl.getProtocol().toLowerCase(Locale.ROOT).equals("file")) {
            Path p = cu.validateFile("sasl.oauthbearer.jwks.endpoint.url");
            return new JwksFileVerificationKeyResolver(p);
        }
        long refreshIntervalMs = cu.validateLong("sasl.oauthbearer.jwks.endpoint.refresh.ms", true, 0L);
        JaasOptionsUtils jou = new JaasOptionsUtils(jaasConfig);
        SSLSocketFactory sslSocketFactory = null;
        if (jou.shouldCreateSSLSocketFactory(jwksEndpointUrl)) {
            sslSocketFactory = jou.createSSLSocketFactory();
        }
        HttpsJwks httpsJwks = new HttpsJwks(jwksEndpointUrl.toString());
        httpsJwks.setDefaultCacheDuration(refreshIntervalMs);
        if (sslSocketFactory != null) {
            Get get = new Get();
            get.setSslSocketFactory(sslSocketFactory);
            httpsJwks.setSimpleHttpGet((SimpleGet)get);
        }
        RefreshingHttpsJwks refreshingHttpsJwks = new RefreshingHttpsJwks(Time.SYSTEM, httpsJwks, refreshIntervalMs, cu.validateLong("sasl.oauthbearer.jwks.endpoint.retry.backoff.ms"), cu.validateLong("sasl.oauthbearer.jwks.endpoint.retry.backoff.max.ms"));
        return new RefreshingHttpsJwksVerificationKeyResolver(refreshingHttpsJwks);
    }
}

