/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured;

import java.util.concurrent.ExecutionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.Retryable;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.security.oauthbearer.secured.UnretryableException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retry<R> {
    private static final Logger log = LoggerFactory.getLogger(Retry.class);
    private final Time time;
    private final long retryBackoffMs;
    private final long retryBackoffMaxMs;

    public Retry(long retryBackoffMs, long retryBackoffMaxMs) {
        this(Time.SYSTEM, retryBackoffMs, retryBackoffMaxMs);
    }

    public Retry(Time time, long retryBackoffMs, long retryBackoffMaxMs) {
        this.time = time;
        this.retryBackoffMs = retryBackoffMs;
        this.retryBackoffMaxMs = retryBackoffMaxMs;
        if (this.retryBackoffMs < 0L) {
            throw new IllegalArgumentException(String.format("retryBackoffMs value (%s) must be non-negative", retryBackoffMs));
        }
        if (this.retryBackoffMaxMs < 0L) {
            throw new IllegalArgumentException(String.format("retryBackoffMaxMs value (%s) must be non-negative", retryBackoffMaxMs));
        }
        if (this.retryBackoffMaxMs < this.retryBackoffMs) {
            throw new IllegalArgumentException(String.format("retryBackoffMaxMs value (%s) is less than retryBackoffMs value (%s)", retryBackoffMaxMs, retryBackoffMs));
        }
    }

    public R execute(Retryable<R> retryable) throws ExecutionException {
        long endMs = this.time.milliseconds() + this.retryBackoffMaxMs;
        int currAttempt = 0;
        ExecutionException error = null;
        while (this.time.milliseconds() <= endMs) {
            ++currAttempt;
            try {
                return retryable.call();
            }
            catch (UnretryableException e) {
                if (error != null) break;
                error = new ExecutionException(e);
                break;
            }
            catch (ExecutionException e) {
                log.warn("Error during retry attempt {}", (Object)currAttempt, (Object)e);
                if (error == null) {
                    error = e;
                }
                long waitMs = this.retryBackoffMs * (long)Math.pow(2.0, currAttempt - 1);
                long diff = endMs - this.time.milliseconds();
                if ((waitMs = Math.min(waitMs, diff)) <= 0L) break;
                String message = String.format("Attempt %s to make call resulted in an error; sleeping %s ms before retrying", currAttempt, waitMs);
                log.warn(message, (Throwable)e);
                this.time.sleep(waitMs);
            }
        }
        if (error == null) {
            error = new ExecutionException(new IllegalStateException("Exhausted all retry attempts but no attempt returned value or encountered exception"));
        }
        throw error;
    }
}

