/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.Uuid;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.CreateTopicsResponseData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;

public class CreateTopicsResponseDataJsonConverter {
    public static CreateTopicsResponseData read(JsonNode _node, short _version) {
        CreateTopicsResponseData.CreatableTopicResultCollection _collection;
        CreateTopicsResponseData _object = new CreateTopicsResponseData();
        JsonNode _throttleTimeMsNode = _node.get("throttleTimeMs");
        if (_throttleTimeMsNode == null) {
            if (_version >= 2) {
                throw new RuntimeException("CreateTopicsResponseData: unable to locate field 'throttleTimeMs', which is mandatory in version " + _version);
            }
            _object.throttleTimeMs = 0;
        } else {
            _object.throttleTimeMs = MessageUtil.jsonNodeToInt(_throttleTimeMsNode, "CreateTopicsResponseData");
        }
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("CreateTopicsResponseData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("CreateTopicsResponseData expected a JSON array, but got " + _node.getNodeType());
        }
        _object.topics = _collection = new CreateTopicsResponseData.CreatableTopicResultCollection(_topicsNode.size());
        for (JsonNode _element : _topicsNode) {
            _collection.add(CreatableTopicResultJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(CreateTopicsResponseData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        if (_version >= 2) {
            _node.set("throttleTimeMs", (JsonNode)new IntNode(_object.throttleTimeMs));
        }
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (CreateTopicsResponseData.CreatableTopicResult _element : _object.topics) {
            _topicsArray.add(CreatableTopicResultJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(CreateTopicsResponseData _object, short _version) {
        return CreateTopicsResponseDataJsonConverter.write(_object, _version, true);
    }

    public static class CreatableTopicResultJsonConverter {
        public static CreateTopicsResponseData.CreatableTopicResult read(JsonNode _node, short _version) {
            CreateTopicsResponseData.CreatableTopicResult _object = new CreateTopicsResponseData.CreatableTopicResult();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopicResult: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopicResult expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _topicIdNode = _node.get("topicId");
            if (_topicIdNode == null) {
                if (_version >= 7) {
                    throw new RuntimeException("CreatableTopicResult: unable to locate field 'topicId', which is mandatory in version " + _version);
                }
                _object.topicId = Uuid.ZERO_UUID;
            } else {
                if (!_topicIdNode.isTextual()) {
                    throw new RuntimeException("CreatableTopicResult expected a JSON string type, but got " + _node.getNodeType());
                }
                _object.topicId = Uuid.fromString(_topicIdNode.asText());
            }
            JsonNode _errorCodeNode = _node.get("errorCode");
            if (_errorCodeNode == null) {
                throw new RuntimeException("CreatableTopicResult: unable to locate field 'errorCode', which is mandatory in version " + _version);
            }
            _object.errorCode = MessageUtil.jsonNodeToShort(_errorCodeNode, "CreatableTopicResult");
            JsonNode _errorMessageNode = _node.get("errorMessage");
            if (_errorMessageNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("CreatableTopicResult: unable to locate field 'errorMessage', which is mandatory in version " + _version);
                }
                _object.errorMessage = "";
            } else if (_errorMessageNode.isNull()) {
                _object.errorMessage = null;
            } else {
                if (!_errorMessageNode.isTextual()) {
                    throw new RuntimeException("CreatableTopicResult expected a string type, but got " + _node.getNodeType());
                }
                _object.errorMessage = _errorMessageNode.asText();
            }
            JsonNode _topicConfigErrorCodeNode = _node.get("topicConfigErrorCode");
            _object.topicConfigErrorCode = _topicConfigErrorCodeNode == null ? (short)0 : MessageUtil.jsonNodeToShort(_topicConfigErrorCodeNode, "CreatableTopicResult");
            JsonNode _numPartitionsNode = _node.get("numPartitions");
            if (_numPartitionsNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("CreatableTopicResult: unable to locate field 'numPartitions', which is mandatory in version " + _version);
                }
                _object.numPartitions = -1;
            } else {
                _object.numPartitions = MessageUtil.jsonNodeToInt(_numPartitionsNode, "CreatableTopicResult");
            }
            JsonNode _replicationFactorNode = _node.get("replicationFactor");
            if (_replicationFactorNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("CreatableTopicResult: unable to locate field 'replicationFactor', which is mandatory in version " + _version);
                }
                _object.replicationFactor = (short)-1;
            } else {
                _object.replicationFactor = MessageUtil.jsonNodeToShort(_replicationFactorNode, "CreatableTopicResult");
            }
            JsonNode _configsNode = _node.get("configs");
            if (_configsNode == null) {
                if (_version >= 5) {
                    throw new RuntimeException("CreatableTopicResult: unable to locate field 'configs', which is mandatory in version " + _version);
                }
                _object.configs = new ArrayList<CreateTopicsResponseData.CreatableTopicConfigs>(0);
            } else if (_configsNode.isNull()) {
                _object.configs = null;
            } else {
                if (!_configsNode.isArray()) {
                    throw new RuntimeException("CreatableTopicResult expected a JSON array, but got " + _node.getNodeType());
                }
                ArrayList<CreateTopicsResponseData.CreatableTopicConfigs> _collection = new ArrayList<CreateTopicsResponseData.CreatableTopicConfigs>(_configsNode.size());
                _object.configs = _collection;
                for (JsonNode _element : _configsNode) {
                    _collection.add(CreatableTopicConfigsJsonConverter.read(_element, _version));
                }
            }
            return _object;
        }

        public static JsonNode write(CreateTopicsResponseData.CreatableTopicResult _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            if (_version >= 7) {
                _node.set("topicId", (JsonNode)new TextNode(_object.topicId.toString()));
            }
            _node.set("errorCode", (JsonNode)new ShortNode(_object.errorCode));
            if (_version >= 1) {
                if (_object.errorMessage == null) {
                    _node.set("errorMessage", (JsonNode)NullNode.instance);
                } else {
                    _node.set("errorMessage", (JsonNode)new TextNode(_object.errorMessage));
                }
            }
            if (_version >= 5 && _object.topicConfigErrorCode != 0) {
                _node.set("topicConfigErrorCode", (JsonNode)new ShortNode(_object.topicConfigErrorCode));
            }
            if (_version >= 5) {
                _node.set("numPartitions", (JsonNode)new IntNode(_object.numPartitions));
            }
            if (_version >= 5) {
                _node.set("replicationFactor", (JsonNode)new ShortNode(_object.replicationFactor));
            }
            if (_version >= 5) {
                if (_object.configs == null) {
                    _node.set("configs", (JsonNode)NullNode.instance);
                } else {
                    ArrayNode _configsArray = new ArrayNode(JsonNodeFactory.instance);
                    for (CreateTopicsResponseData.CreatableTopicConfigs _element : _object.configs) {
                        _configsArray.add(CreatableTopicConfigsJsonConverter.write(_element, _version, _serializeRecords));
                    }
                    _node.set("configs", (JsonNode)_configsArray);
                }
            }
            return _node;
        }

        public static JsonNode write(CreateTopicsResponseData.CreatableTopicResult _object, short _version) {
            return CreatableTopicResultJsonConverter.write(_object, _version, true);
        }
    }

    public static class CreatableTopicConfigsJsonConverter {
        public static CreateTopicsResponseData.CreatableTopicConfigs read(JsonNode _node, short _version) {
            CreateTopicsResponseData.CreatableTopicConfigs _object = new CreateTopicsResponseData.CreatableTopicConfigs();
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of CreatableTopicConfigs");
            }
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("CreatableTopicConfigs: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("CreatableTopicConfigs expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _valueNode = _node.get("value");
            if (_valueNode == null) {
                throw new RuntimeException("CreatableTopicConfigs: unable to locate field 'value', which is mandatory in version " + _version);
            }
            if (_valueNode.isNull()) {
                _object.value = null;
            } else {
                if (!_valueNode.isTextual()) {
                    throw new RuntimeException("CreatableTopicConfigs expected a string type, but got " + _node.getNodeType());
                }
                _object.value = _valueNode.asText();
            }
            JsonNode _readOnlyNode = _node.get("readOnly");
            if (_readOnlyNode == null) {
                throw new RuntimeException("CreatableTopicConfigs: unable to locate field 'readOnly', which is mandatory in version " + _version);
            }
            if (!_readOnlyNode.isBoolean()) {
                throw new RuntimeException("CreatableTopicConfigs expected Boolean type, but got " + _node.getNodeType());
            }
            _object.readOnly = _readOnlyNode.asBoolean();
            JsonNode _configSourceNode = _node.get("configSource");
            if (_configSourceNode == null) {
                throw new RuntimeException("CreatableTopicConfigs: unable to locate field 'configSource', which is mandatory in version " + _version);
            }
            _object.configSource = MessageUtil.jsonNodeToByte(_configSourceNode, "CreatableTopicConfigs");
            JsonNode _isSensitiveNode = _node.get("isSensitive");
            if (_isSensitiveNode == null) {
                throw new RuntimeException("CreatableTopicConfigs: unable to locate field 'isSensitive', which is mandatory in version " + _version);
            }
            if (!_isSensitiveNode.isBoolean()) {
                throw new RuntimeException("CreatableTopicConfigs expected Boolean type, but got " + _node.getNodeType());
            }
            _object.isSensitive = _isSensitiveNode.asBoolean();
            return _object;
        }

        public static JsonNode write(CreateTopicsResponseData.CreatableTopicConfigs _object, short _version, boolean _serializeRecords) {
            if (_version < 5) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of CreatableTopicConfigs");
            }
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            if (_object.value == null) {
                _node.set("value", (JsonNode)NullNode.instance);
            } else {
                _node.set("value", (JsonNode)new TextNode(_object.value));
            }
            _node.set("readOnly", (JsonNode)BooleanNode.valueOf((boolean)_object.readOnly));
            _node.set("configSource", (JsonNode)new ShortNode((short)_object.configSource));
            _node.set("isSensitive", (JsonNode)BooleanNode.valueOf((boolean)_object.isSensitive));
            return _node;
        }

        public static JsonNode write(CreateTopicsResponseData.CreatableTopicConfigs _object, short _version) {
            return CreatableTopicConfigsJsonConverter.write(_object, _version, true);
        }
    }
}

