/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kafka.shaded.org.apache.kafka.common.message;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.message.AlterPartitionRequestData;
import org.apache.flink.kafka.shaded.org.apache.kafka.common.protocol.MessageUtil;

public class AlterPartitionRequestDataJsonConverter {
    public static AlterPartitionRequestData read(JsonNode _node, short _version) {
        AlterPartitionRequestData _object = new AlterPartitionRequestData();
        JsonNode _brokerIdNode = _node.get("brokerId");
        if (_brokerIdNode == null) {
            throw new RuntimeException("AlterPartitionRequestData: unable to locate field 'brokerId', which is mandatory in version " + _version);
        }
        _object.brokerId = MessageUtil.jsonNodeToInt(_brokerIdNode, "AlterPartitionRequestData");
        JsonNode _brokerEpochNode = _node.get("brokerEpoch");
        if (_brokerEpochNode == null) {
            throw new RuntimeException("AlterPartitionRequestData: unable to locate field 'brokerEpoch', which is mandatory in version " + _version);
        }
        _object.brokerEpoch = MessageUtil.jsonNodeToLong(_brokerEpochNode, "AlterPartitionRequestData");
        JsonNode _topicsNode = _node.get("topics");
        if (_topicsNode == null) {
            throw new RuntimeException("AlterPartitionRequestData: unable to locate field 'topics', which is mandatory in version " + _version);
        }
        if (!_topicsNode.isArray()) {
            throw new RuntimeException("AlterPartitionRequestData expected a JSON array, but got " + _node.getNodeType());
        }
        ArrayList<AlterPartitionRequestData.TopicData> _collection = new ArrayList<AlterPartitionRequestData.TopicData>(_topicsNode.size());
        _object.topics = _collection;
        for (JsonNode _element : _topicsNode) {
            _collection.add(TopicDataJsonConverter.read(_element, _version));
        }
        return _object;
    }

    public static JsonNode write(AlterPartitionRequestData _object, short _version, boolean _serializeRecords) {
        ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
        _node.set("brokerId", (JsonNode)new IntNode(_object.brokerId));
        _node.set("brokerEpoch", (JsonNode)new LongNode(_object.brokerEpoch));
        ArrayNode _topicsArray = new ArrayNode(JsonNodeFactory.instance);
        for (AlterPartitionRequestData.TopicData _element : _object.topics) {
            _topicsArray.add(TopicDataJsonConverter.write(_element, _version, _serializeRecords));
        }
        _node.set("topics", (JsonNode)_topicsArray);
        return _node;
    }

    public static JsonNode write(AlterPartitionRequestData _object, short _version) {
        return AlterPartitionRequestDataJsonConverter.write(_object, _version, true);
    }

    public static class TopicDataJsonConverter {
        public static AlterPartitionRequestData.TopicData read(JsonNode _node, short _version) {
            AlterPartitionRequestData.TopicData _object = new AlterPartitionRequestData.TopicData();
            JsonNode _nameNode = _node.get("name");
            if (_nameNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'name', which is mandatory in version " + _version);
            }
            if (!_nameNode.isTextual()) {
                throw new RuntimeException("TopicData expected a string type, but got " + _node.getNodeType());
            }
            _object.name = _nameNode.asText();
            JsonNode _partitionsNode = _node.get("partitions");
            if (_partitionsNode == null) {
                throw new RuntimeException("TopicData: unable to locate field 'partitions', which is mandatory in version " + _version);
            }
            if (!_partitionsNode.isArray()) {
                throw new RuntimeException("TopicData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<AlterPartitionRequestData.PartitionData> _collection = new ArrayList<AlterPartitionRequestData.PartitionData>(_partitionsNode.size());
            _object.partitions = _collection;
            for (JsonNode _element : _partitionsNode) {
                _collection.add(PartitionDataJsonConverter.read(_element, _version));
            }
            return _object;
        }

        public static JsonNode write(AlterPartitionRequestData.TopicData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("name", (JsonNode)new TextNode(_object.name));
            ArrayNode _partitionsArray = new ArrayNode(JsonNodeFactory.instance);
            for (AlterPartitionRequestData.PartitionData _element : _object.partitions) {
                _partitionsArray.add(PartitionDataJsonConverter.write(_element, _version, _serializeRecords));
            }
            _node.set("partitions", (JsonNode)_partitionsArray);
            return _node;
        }

        public static JsonNode write(AlterPartitionRequestData.TopicData _object, short _version) {
            return TopicDataJsonConverter.write(_object, _version, true);
        }
    }

    public static class PartitionDataJsonConverter {
        public static AlterPartitionRequestData.PartitionData read(JsonNode _node, short _version) {
            AlterPartitionRequestData.PartitionData _object = new AlterPartitionRequestData.PartitionData();
            JsonNode _partitionIndexNode = _node.get("partitionIndex");
            if (_partitionIndexNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionIndex', which is mandatory in version " + _version);
            }
            _object.partitionIndex = MessageUtil.jsonNodeToInt(_partitionIndexNode, "PartitionData");
            JsonNode _leaderEpochNode = _node.get("leaderEpoch");
            if (_leaderEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'leaderEpoch', which is mandatory in version " + _version);
            }
            _object.leaderEpoch = MessageUtil.jsonNodeToInt(_leaderEpochNode, "PartitionData");
            JsonNode _newIsrNode = _node.get("newIsr");
            if (_newIsrNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'newIsr', which is mandatory in version " + _version);
            }
            if (!_newIsrNode.isArray()) {
                throw new RuntimeException("PartitionData expected a JSON array, but got " + _node.getNodeType());
            }
            ArrayList<Integer> _collection = new ArrayList<Integer>(_newIsrNode.size());
            _object.newIsr = _collection;
            for (JsonNode _element : _newIsrNode) {
                _collection.add(MessageUtil.jsonNodeToInt(_element, "PartitionData element"));
            }
            JsonNode _leaderRecoveryStateNode = _node.get("leaderRecoveryState");
            if (_leaderRecoveryStateNode == null) {
                if (_version >= 1) {
                    throw new RuntimeException("PartitionData: unable to locate field 'leaderRecoveryState', which is mandatory in version " + _version);
                }
                _object.leaderRecoveryState = 0;
            } else {
                _object.leaderRecoveryState = MessageUtil.jsonNodeToByte(_leaderRecoveryStateNode, "PartitionData");
            }
            JsonNode _partitionEpochNode = _node.get("partitionEpoch");
            if (_partitionEpochNode == null) {
                throw new RuntimeException("PartitionData: unable to locate field 'partitionEpoch', which is mandatory in version " + _version);
            }
            _object.partitionEpoch = MessageUtil.jsonNodeToInt(_partitionEpochNode, "PartitionData");
            return _object;
        }

        public static JsonNode write(AlterPartitionRequestData.PartitionData _object, short _version, boolean _serializeRecords) {
            ObjectNode _node = new ObjectNode(JsonNodeFactory.instance);
            _node.set("partitionIndex", (JsonNode)new IntNode(_object.partitionIndex));
            _node.set("leaderEpoch", (JsonNode)new IntNode(_object.leaderEpoch));
            ArrayNode _newIsrArray = new ArrayNode(JsonNodeFactory.instance);
            for (Integer _element : _object.newIsr) {
                _newIsrArray.add((JsonNode)new IntNode(_element.intValue()));
            }
            _node.set("newIsr", (JsonNode)_newIsrArray);
            if (_version >= 1) {
                _node.set("leaderRecoveryState", (JsonNode)new ShortNode((short)_object.leaderRecoveryState));
            } else if (_object.leaderRecoveryState != 0) {
                throw new UnsupportedVersionException("Attempted to write a non-default leaderRecoveryState at version " + _version);
            }
            _node.set("partitionEpoch", (JsonNode)new IntNode(_object.partitionEpoch));
            return _node;
        }

        public static JsonNode write(AlterPartitionRequestData.PartitionData _object, short _version) {
            return PartitionDataJsonConverter.write(_object, _version, true);
        }
    }
}

