/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.elasticsearch.table;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.elasticsearch7.shaded.org.apache.http.HttpHost;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchConfiguration;
import org.apache.flink.streaming.connectors.elasticsearch.table.ElasticsearchConnectorOptions;
import org.apache.flink.table.api.ValidationException;

@Internal
final class Elasticsearch7Configuration
extends ElasticsearchConfiguration {
    Elasticsearch7Configuration(ReadableConfig config, ClassLoader classLoader) {
        super(config, classLoader);
    }

    public List<HttpHost> getHosts() {
        return ((List)this.config.get(ElasticsearchConnectorOptions.HOSTS_OPTION)).stream().map(Elasticsearch7Configuration::validateAndParseHostsString).collect(Collectors.toList());
    }

    private static HttpHost validateAndParseHostsString(String host) {
        try {
            HttpHost httpHost = HttpHost.create(host);
            if (httpHost.getPort() < 0) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing port.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            if (httpHost.getSchemeName() == null) {
                throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'. Missing scheme.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()));
            }
            return httpHost;
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Could not parse host '%s' in option '%s'. It should follow the format 'http://host_name:port'.", host, ElasticsearchConnectorOptions.HOSTS_OPTION.key()), (Throwable)e);
        }
    }
}

