/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.heuristic;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchParseException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristic;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.bucket.terms.heuristic.SignificanceHeuristicBuilder;

public class PercentageScore
extends SignificanceHeuristic {
    public static final String NAME = "percentage";
    public static final ObjectParser<PercentageScore, Void> PARSER = new ObjectParser("percentage", PercentageScore::new);

    public PercentageScore() {
    }

    public PercentageScore(StreamInput in) {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME).endObject();
        return builder;
    }

    public static SignificanceHeuristic parse(XContentParser parser) throws IOException, QueryShardException {
        if (!parser.nextToken().equals((Object)XContentParser.Token.END_OBJECT)) {
            throw new ElasticsearchParseException("failed to parse [percentage] significance heuristic. expected an empty object, but got [{}] instead", new Object[]{parser.currentToken()});
        }
        return new PercentageScore();
    }

    @Override
    public double getScore(long subsetFreq, long subsetSize, long supersetFreq, long supersetSize) {
        this.checkFrequencyValidity(subsetFreq, subsetSize, supersetFreq, supersetSize, "PercentageScore");
        if (supersetFreq == 0L) {
            return 0.0;
        }
        return (double)subsetFreq / (double)supersetFreq;
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class PercentageScoreBuilder
    implements SignificanceHeuristicBuilder {
        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject(PercentageScore.NAME).endObject();
            return builder;
        }
    }
}

