/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.snapshots.blobstore;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;

public class SnapshotFiles {
    private final String snapshot;
    private final List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles;
    @Nullable
    private final String shardStateIdentifier;
    private Map<String, BlobStoreIndexShardSnapshot.FileInfo> physicalFiles = null;

    public String snapshot() {
        return this.snapshot;
    }

    public SnapshotFiles(String snapshot, List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles, @Nullable String shardStateIdentifier) {
        this.snapshot = snapshot;
        this.indexFiles = indexFiles;
        this.shardStateIdentifier = shardStateIdentifier;
    }

    public SnapshotFiles withSnapshotName(String snapshotName) {
        return new SnapshotFiles(snapshotName, this.indexFiles, this.shardStateIdentifier);
    }

    public boolean isSame(SnapshotFiles other) {
        if (!Objects.equals(this.shardStateIdentifier, other.shardStateIdentifier)) {
            return false;
        }
        int fileCount = this.indexFiles.size();
        if (other.indexFiles.size() != fileCount) {
            return false;
        }
        for (int i = 0; i < fileCount; ++i) {
            if (this.indexFiles.get(i).isSame(other.indexFiles.get(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public String shardStateIdentifier() {
        return this.shardStateIdentifier;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> indexFiles() {
        return this.indexFiles;
    }

    public boolean containPhysicalIndexFile(String physicalName) {
        return this.findPhysicalIndexFile(physicalName) != null;
    }

    public BlobStoreIndexShardSnapshot.FileInfo findPhysicalIndexFile(String physicalName) {
        if (this.physicalFiles == null) {
            HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : this.indexFiles) {
                files.put(fileInfo.physicalName(), fileInfo);
            }
            this.physicalFiles = files;
        }
        return this.physicalFiles.get(physicalName);
    }
}

