/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParsingException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ConstantFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.AbstractQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.BaseTermQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.MatchNoneQueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryRewriteContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.query.QueryShardContext;

public class TermQueryBuilder
extends BaseTermQueryBuilder<TermQueryBuilder> {
    public static final String NAME = "term";
    public static final boolean DEFAULT_CASE_INSENSITIVITY = false;
    private static final ParseField CASE_INSENSITIVE_FIELD = new ParseField("case_insensitive", new String[0]);
    private boolean caseInsensitive = false;
    private static final ParseField TERM_FIELD = new ParseField("term", new String[0]);
    private static final ParseField VALUE_FIELD = new ParseField("value", new String[0]);

    public TermQueryBuilder(String fieldName, String value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, int value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, long value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, float value) {
        super(fieldName, Float.valueOf(value));
    }

    public TermQueryBuilder(String fieldName, double value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, boolean value) {
        super(fieldName, (Object)value);
    }

    public TermQueryBuilder(String fieldName, Object value) {
        super(fieldName, value);
    }

    public TermQueryBuilder caseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return this;
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public TermQueryBuilder(StreamInput in) throws IOException {
        super(in);
        if (in.getVersion().onOrAfter(Version.V_7_10_0)) {
            this.caseInsensitive = in.readBoolean();
        }
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        super.doWriteTo(out);
        if (out.getVersion().onOrAfter(Version.V_7_10_0)) {
            out.writeBoolean(this.caseInsensitive);
        }
    }

    public static TermQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String queryName = null;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        boolean caseInsensitive = false;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (TERM_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (VALUE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                        continue;
                    }
                    if (AbstractQueryBuilder.NAME_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        queryName = parser.text();
                        continue;
                    }
                    if (AbstractQueryBuilder.BOOST_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        boost = parser.floatValue();
                        continue;
                    }
                    if (CASE_INSENSITIVE_FIELD.match(currentFieldName, parser.getDeprecationHandler())) {
                        caseInsensitive = parser.booleanValue();
                        continue;
                    }
                    throw new ParsingException(parser.getTokenLocation(), "[term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                TermQueryBuilder.throwParsingExceptionOnMultipleFields(NAME, parser.getTokenLocation(), fieldName, parser.currentName());
                fieldName = currentFieldName;
                value = TermQueryBuilder.maybeConvertToBytesRef(parser.objectBytes());
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            throw new ParsingException(parser.getTokenLocation(), "[term] query does not support array of values", new Object[0]);
        }
        TermQueryBuilder termQuery = new TermQueryBuilder(fieldName, value);
        termQuery.boost(boost);
        if (queryName != null) {
            termQuery.queryName(queryName);
        }
        termQuery.caseInsensitive(caseInsensitive);
        return termQuery;
    }

    @Override
    protected void addExtraXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.caseInsensitive) {
            builder.field(CASE_INSENSITIVE_FIELD.getPreferredName(), this.caseInsensitive);
        }
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        QueryShardContext context = queryRewriteContext.convertToShardContext();
        if (context != null) {
            MappedFieldType fieldType = context.fieldMapper(this.fieldName);
            if (fieldType == null) {
                return new MatchNoneQueryBuilder();
            }
            if (fieldType instanceof ConstantFieldType) {
                Query query = null;
                query = this.caseInsensitive ? fieldType.termQueryCaseInsensitive(this.value, context) : fieldType.termQuery(this.value, context);
                if (query instanceof MatchAllDocsQuery) {
                    return new MatchAllQueryBuilder();
                }
                if (query instanceof MatchNoDocsQuery) {
                    return new MatchNoneQueryBuilder();
                }
                assert (false) : "Constant fields must produce match-all or match-none queries, got " + query;
            }
        }
        return super.doRewrite(queryRewriteContext);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType mapper = context.fieldMapper(this.fieldName);
        if (mapper == null) {
            throw new IllegalStateException("Rewrite first");
        }
        if (this.caseInsensitive) {
            return mapper.termQueryCaseInsensitive(this.value, context);
        }
        return mapper.termQuery(this.value, context);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected final int doHashCode() {
        return Objects.hash(super.doHashCode(), this.caseInsensitive);
    }

    @Override
    protected final boolean doEquals(TermQueryBuilder other) {
        return super.doEquals(other) && Objects.equals(this.caseInsensitive, other.caseInsensitive);
    }
}

