/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.collect.List;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SourceLookup;

public abstract class SourceValueFetcher
implements ValueFetcher {
    private final Set<String> sourcePaths;
    @Nullable
    private final Object nullValue;

    public SourceValueFetcher(String fieldName, MapperService mapperService) {
        this(fieldName, mapperService, null);
    }

    public SourceValueFetcher(String fieldName, MapperService mapperService, Object nullValue) {
        this.sourcePaths = mapperService.sourcePath(fieldName);
        this.nullValue = nullValue;
    }

    @Override
    public java.util.List<Object> fetchValues(SourceLookup lookup) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (String path : this.sourcePaths) {
            Object sourceValue = lookup.extractValue(path, this.nullValue);
            if (sourceValue == null) {
                return List.of();
            }
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(sourceValue);
            while (!queue.isEmpty()) {
                Object value = queue.poll();
                if (value instanceof java.util.List) {
                    queue.addAll((java.util.List)value);
                    continue;
                }
                Object parsedValue = this.parseSourceValue(value);
                if (parsedValue == null) continue;
                values.add(parsedValue);
            }
        }
        return values;
    }

    protected abstract Object parseSourceValue(Object var1);

    public static SourceValueFetcher identity(String fieldName, MapperService mapperService, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, mapperService){

            @Override
            protected Object parseSourceValue(Object value) {
                return value;
            }
        };
    }

    public static SourceValueFetcher toString(String fieldName, MapperService mapperService, String format) {
        if (format != null) {
            throw new IllegalArgumentException("Field [" + fieldName + "] doesn't support formats.");
        }
        return new SourceValueFetcher(fieldName, mapperService){

            @Override
            protected Object parseSourceValue(Object value) {
                return value.toString();
            }
        };
    }
}

