/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis;

import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.miscellaneous.DisableGraphAttribute;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.shingle.ShingleFilter;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.logging.DeprecationLogger;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.env.Environment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.IndexSettings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.AbstractTokenFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;

public class ShingleTokenFilterFactory
extends AbstractTokenFilterFactory {
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(ShingleTokenFilterFactory.class);
    private final Factory factory;

    public ShingleTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        int maxAllowedShingleDiff = indexSettings.getMaxShingleDiff();
        Integer maxShingleSize = settings.getAsInt("max_shingle_size", 2);
        Integer minShingleSize = settings.getAsInt("min_shingle_size", 2);
        Boolean outputUnigrams = settings.getAsBoolean("output_unigrams", true);
        int shingleDiff = maxShingleSize - minShingleSize + (outputUnigrams != false ? 1 : 0);
        if (shingleDiff > maxAllowedShingleDiff) {
            if (indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
                throw new IllegalArgumentException("In Shingle TokenFilter the difference between max_shingle_size and min_shingle_size (and +1 if outputting unigrams) must be less than or equal to: [" + maxAllowedShingleDiff + "] but was [" + shingleDiff + "]. This limit can be set by changing the [" + IndexSettings.MAX_SHINGLE_DIFF_SETTING.getKey() + "] index level setting.");
            }
            this.deprecationLogger.deprecate("excessive_shingle_diff", "Deprecated big difference between maxShingleSize and minShingleSize in Shingle TokenFilter, expected difference must be less than or equal to: [" + maxAllowedShingleDiff + "]", new Object[0]);
        }
        Boolean outputUnigramsIfNoShingles = settings.getAsBoolean("output_unigrams_if_no_shingles", false);
        String tokenSeparator = settings.get("token_separator", " ");
        String fillerToken = settings.get("filler_token", "_");
        this.factory = new Factory("shingle", minShingleSize, maxShingleSize, outputUnigrams, outputUnigramsIfNoShingles, tokenSeparator, fillerToken);
    }

    @Override
    public TokenStream create(TokenStream tokenStream) {
        return this.factory.create(tokenStream);
    }

    @Override
    public TokenFilterFactory getSynonymFilter() {
        if (this.indexSettings.getIndexVersionCreated().onOrAfter(Version.V_7_0_0)) {
            throw new IllegalArgumentException("Token filter [" + this.name() + "] cannot be used to parse synonyms");
        }
        DEPRECATION_LOGGER.deprecate("synonym_tokenfilters", "Token filter " + this.name() + "] will not be usable to parse synonym after v7.0", new Object[0]);
        return this;
    }

    public Factory getInnerFactory() {
        return this.factory;
    }

    public static final class Factory
    implements TokenFilterFactory {
        private final int maxShingleSize;
        private final boolean outputUnigrams;
        private final boolean outputUnigramsIfNoShingles;
        private final String tokenSeparator;
        private final String fillerToken;
        private int minShingleSize;
        private final String name;

        public Factory(String name) {
            this(name, 2, 2, true, false, " ", "_");
        }

        Factory(String name, int minShingleSize, int maxShingleSize, boolean outputUnigrams, boolean outputUnigramsIfNoShingles, String tokenSeparator, String fillerToken) {
            this.maxShingleSize = maxShingleSize;
            this.outputUnigrams = outputUnigrams;
            this.outputUnigramsIfNoShingles = outputUnigramsIfNoShingles;
            this.tokenSeparator = tokenSeparator;
            this.minShingleSize = minShingleSize;
            this.fillerToken = fillerToken;
            this.name = name;
        }

        @Override
        public TokenStream create(TokenStream tokenStream) {
            ShingleFilter filter = new ShingleFilter(tokenStream, this.minShingleSize, this.maxShingleSize);
            filter.setOutputUnigrams(this.outputUnigrams);
            filter.setOutputUnigramsIfNoShingles(this.outputUnigramsIfNoShingles);
            filter.setTokenSeparator(this.tokenSeparator);
            filter.setFillerToken(this.fillerToken);
            if (this.outputUnigrams || this.minShingleSize != this.maxShingleSize) {
                filter.addAttribute(DisableGraphAttribute.class);
            }
            return filter;
        }

        public int getMaxShingleSize() {
            return this.maxShingleSize;
        }

        public int getMinShingleSize() {
            return this.minShingleSize;
        }

        public boolean getOutputUnigrams() {
            return this.outputUnigrams;
        }

        public boolean getOutputUnigramsIfNoShingles() {
            return this.outputUnigramsIfNoShingles;
        }

        @Override
        public String name() {
            return this.name;
        }
    }
}

