/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis;

import java.io.Reader;
import java.util.Map;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Analyzer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.TokenStream;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.analysis.Tokenizer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.CloseableThreadLocal;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.util.CollectionUtils;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.AnalysisMode;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.AnalyzerComponents;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.AnalyzerComponentsProvider;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.CharFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.TokenFilterFactory;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.analysis.TokenizerFactory;

public final class ReloadableCustomAnalyzer
extends Analyzer
implements AnalyzerComponentsProvider {
    private volatile AnalyzerComponents components;
    private CloseableThreadLocal<AnalyzerComponents> storedComponents = new CloseableThreadLocal();
    private final int positionIncrementGap;
    private final int offsetGap;
    private static final Analyzer.ReuseStrategy UPDATE_STRATEGY = new Analyzer.ReuseStrategy(){

        @Override
        public Analyzer.TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            ReloadableCustomAnalyzer custom = (ReloadableCustomAnalyzer)analyzer;
            AnalyzerComponents components = custom.getComponents();
            AnalyzerComponents storedComponents = custom.getStoredComponents();
            if (storedComponents == null || components != storedComponents) {
                custom.setStoredComponents(components);
                return null;
            }
            Analyzer.TokenStreamComponents tokenStream = (Analyzer.TokenStreamComponents)this.getStoredValue(analyzer);
            assert (tokenStream != null);
            return tokenStream;
        }

        @Override
        public void setReusableComponents(Analyzer analyzer, String fieldName, Analyzer.TokenStreamComponents tokenStream) {
            this.setStoredValue(analyzer, tokenStream);
        }
    };

    ReloadableCustomAnalyzer(AnalyzerComponents components, int positionIncrementGap, int offsetGap) {
        super(UPDATE_STRATEGY);
        if (!components.analysisMode().equals((Object)AnalysisMode.SEARCH_TIME)) {
            throw new IllegalArgumentException("ReloadableCustomAnalyzer must only be initialized with analysis components in AnalysisMode.SEARCH_TIME mode");
        }
        this.components = components;
        this.positionIncrementGap = positionIncrementGap;
        this.offsetGap = offsetGap;
    }

    @Override
    public AnalyzerComponents getComponents() {
        return this.components;
    }

    @Override
    public int getPositionIncrementGap(String fieldName) {
        return this.positionIncrementGap;
    }

    @Override
    public int getOffsetGap(String field) {
        if (this.offsetGap < 0) {
            return super.getOffsetGap(field);
        }
        return this.offsetGap;
    }

    public AnalysisMode getAnalysisMode() {
        return this.components.analysisMode();
    }

    @Override
    protected Reader initReaderForNormalization(String fieldName, Reader reader) {
        AnalyzerComponents components = this.getComponents();
        for (CharFilterFactory charFilter : components.getCharFilters()) {
            reader = charFilter.normalize(reader);
        }
        return reader;
    }

    @Override
    protected TokenStream normalize(String fieldName, TokenStream in) {
        AnalyzerComponents components = this.getComponents();
        TokenStream result = in;
        for (TokenFilterFactory filter : components.getTokenFilters()) {
            result = filter.normalize(result);
        }
        return result;
    }

    public synchronized void reload(String name, Settings settings, Map<String, TokenizerFactory> tokenizers, Map<String, CharFilterFactory> charFilters, Map<String, TokenFilterFactory> tokenFilters) {
        AnalyzerComponents components;
        this.components = components = AnalyzerComponents.createComponents(name, settings, tokenizers, charFilters, tokenFilters);
    }

    @Override
    public void close() {
        super.close();
        this.storedComponents.close();
    }

    private void setStoredComponents(AnalyzerComponents components) {
        this.storedComponents.set(components);
    }

    private AnalyzerComponents getStoredComponents() {
        return this.storedComponents.get();
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        Tokenizer tokenizer;
        AnalyzerComponents components = this.getStoredComponents();
        TokenStream tokenStream = tokenizer = components.getTokenizerFactory().create();
        for (TokenFilterFactory tokenFilter : components.getTokenFilters()) {
            tokenStream = tokenFilter.create(tokenStream);
        }
        return new Analyzer.TokenStreamComponents(tokenizer, tokenStream);
    }

    @Override
    protected Reader initReader(String fieldName, Reader reader) {
        AnalyzerComponents components = this.getStoredComponents();
        if (!CollectionUtils.isEmpty(components.getCharFilters())) {
            for (CharFilterFactory charFilter : components.getCharFilters()) {
                reader = charFilter.create(reader);
            }
        }
        return reader;
    }
}

