/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.InjectorImpl;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.SingleMemberInjector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.SingleParameterInjector;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.Errors;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.ErrorsException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.InternalContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.spi.InjectionPoint;

class SingleMethodInjector
implements SingleMemberInjector {
    final InjectorImpl.MethodInvoker methodInvoker;
    final SingleParameterInjector<?>[] parameterInjectors;
    final InjectionPoint injectionPoint;

    SingleMethodInjector(InjectorImpl injector, InjectionPoint injectionPoint, Errors errors) throws ErrorsException {
        this.injectionPoint = injectionPoint;
        Method method = (Method)injectionPoint.getMember();
        this.methodInvoker = this.createMethodInvoker(method);
        this.parameterInjectors = injector.getParametersInjectors(injectionPoint.getDependencies(), errors);
    }

    private InjectorImpl.MethodInvoker createMethodInvoker(final Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isPrivate(modifiers) || !Modifier.isProtected(modifiers)) {
            // empty if block
        }
        return new InjectorImpl.MethodInvoker(){

            @Override
            public Object invoke(Object target, Object ... parameters) throws IllegalAccessException, InvocationTargetException {
                return method.invoke(target, parameters);
            }
        };
    }

    @Override
    public InjectionPoint getInjectionPoint() {
        return this.injectionPoint;
    }

    @Override
    public void inject(Errors errors, InternalContext context, Object o) {
        Object[] parameters;
        try {
            parameters = SingleParameterInjector.getAll(errors, context, this.parameterInjectors);
        }
        catch (ErrorsException e) {
            errors.merge(e.getErrors());
            return;
        }
        try {
            this.methodInvoker.invoke(o, parameters);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException userException) {
            Throwable cause = userException.getCause() != null ? userException.getCause() : userException;
            errors.withSource(this.injectionPoint).errorInjectingMethod(cause);
        }
    }
}

