/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public class NamedRegistry<T> {
    private final Map<String, T> registry = new HashMap<String, T>();
    private final String targetName;

    public NamedRegistry(String targetName) {
        this.targetName = targetName;
    }

    public Map<String, T> getRegistry() {
        return this.registry;
    }

    public void register(String name, T t) {
        Objects.requireNonNull(name, "name is required");
        Objects.requireNonNull(t, this.targetName + " is required");
        if (this.registry.putIfAbsent(name, t) != null) {
            throw new IllegalArgumentException(this.targetName + " for name [" + name + "] already registered");
        }
    }

    public <P> void extractAndRegister(List<P> plugins, Function<P, Map<String, T>> lookup) {
        for (P plugin : plugins) {
            for (Map.Entry<String, T> entry : lookup.apply(plugin).entrySet()) {
                this.register(entry.getKey(), entry.getValue());
            }
        }
    }
}

