/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.cluster.node;

import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Setting;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.transport.RemoteClusterService;

public abstract class DiscoveryNodeRole
implements Comparable<DiscoveryNodeRole> {
    private final String roleName;
    private final String roleNameAbbreviation;
    private final boolean canContainData;
    private final boolean isKnownRole;
    public static final DiscoveryNodeRole DATA_ROLE = new DiscoveryNodeRole("data", "d", true){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.data", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final DiscoveryNodeRole INGEST_ROLE = new DiscoveryNodeRole("ingest", "i"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.ingest", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final DiscoveryNodeRole MASTER_ROLE = new DiscoveryNodeRole("master", "m"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.master", true, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static final DiscoveryNodeRole REMOTE_CLUSTER_CLIENT_ROLE = new DiscoveryNodeRole("remote_cluster_client", "r"){

        @Override
        public Setting<Boolean> legacySetting() {
            return Setting.boolSetting("node.remote_cluster_client", RemoteClusterService.ENABLE_REMOTE_CLUSTERS, Setting.Property.Deprecated, Setting.Property.NodeScope);
        }
    };
    public static SortedSet<DiscoveryNodeRole> BUILT_IN_ROLES = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, MASTER_ROLE, REMOTE_CLUSTER_CLIENT_ROLE)));
    public static final Version REMOTE_CLUSTER_CLIENT_ROLE_VERSION = Version.V_7_8_0;
    static SortedSet<DiscoveryNodeRole> LEGACY_ROLES = Collections.unmodifiableSortedSet(new TreeSet<DiscoveryNodeRole>(Arrays.asList(DATA_ROLE, INGEST_ROLE, MASTER_ROLE)));

    public final String roleName() {
        return this.roleName;
    }

    public final String roleNameAbbreviation() {
        return this.roleNameAbbreviation;
    }

    public final boolean canContainData() {
        return this.canContainData;
    }

    public final boolean isKnownRole() {
        return this.isKnownRole;
    }

    public boolean isEnabledByDefault(Settings settings) {
        return this.legacySetting() != null && this.legacySetting().get(settings) != false;
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation) {
        this(roleName, roleNameAbbreviation, false);
    }

    protected DiscoveryNodeRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
        this(true, roleName, roleNameAbbreviation, canContainData);
    }

    private DiscoveryNodeRole(boolean isKnownRole, String roleName, String roleNameAbbreviation, boolean canContainData) {
        this.isKnownRole = isKnownRole;
        this.roleName = Objects.requireNonNull(roleName);
        this.roleNameAbbreviation = Objects.requireNonNull(roleNameAbbreviation);
        this.canContainData = canContainData;
    }

    public abstract Setting<Boolean> legacySetting();

    public DiscoveryNodeRole getCompatibilityRole(Version nodeVersion) {
        return this;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiscoveryNodeRole that = (DiscoveryNodeRole)o;
        return this.roleName.equals(that.roleName) && this.roleNameAbbreviation.equals(that.roleNameAbbreviation) && this.canContainData == that.canContainData && this.isKnownRole == that.isKnownRole;
    }

    public final int hashCode() {
        return Objects.hash(this.isKnownRole, this.roleName(), this.roleNameAbbreviation(), this.canContainData());
    }

    @Override
    public final int compareTo(DiscoveryNodeRole o) {
        return this.roleName.compareTo(o.roleName);
    }

    public final String toString() {
        return "DiscoveryNodeRole{roleName='" + this.roleName + '\'' + ", roleNameAbbreviation='" + this.roleNameAbbreviation + '\'' + ", canContainData=" + this.canContainData + (this.isKnownRole ? "" : ", isKnownRole=false") + '}';
    }

    static class UnknownRole
    extends DiscoveryNodeRole {
        UnknownRole(String roleName, String roleNameAbbreviation, boolean canContainData) {
            super(false, roleName, roleNameAbbreviation, canContainData);
        }

        @Override
        public Setting<Boolean> legacySetting() {
            assert (false);
            return Setting.boolSetting("node. " + this.roleName(), false, Setting.Property.NodeScope);
        }
    }
}

