/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.watcher;

import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.Validatable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.watcher.PutWatchRequest;

public final class GetWatchRequest
implements Validatable {
    private final String id;

    public GetWatchRequest(String watchId) {
        this.validateId(watchId);
        this.id = watchId;
    }

    private void validateId(String id) {
        ValidationException exception = new ValidationException();
        if (id == null) {
            exception.addValidationError("watch id is missing");
        } else if (!PutWatchRequest.isValidId(id)) {
            exception.addValidationError("watch id contains whitespace");
        }
        if (!exception.validationErrors().isEmpty()) {
            throw exception;
        }
    }

    public String getId() {
        return this.id;
    }
}

