/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.TaskOperationFailure;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.AcknowledgedTasksResponse;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.transform.transforms.TransformStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;

public class GetTransformStatsResponse {
    public static final ParseField TRANSFORMS = new ParseField("transforms", new String[0]);
    public static final ParseField COUNT = new ParseField("count", new String[0]);
    static final ConstructingObjectParser<GetTransformStatsResponse, Void> PARSER = new ConstructingObjectParser("get_transform_stats_response", true, args -> new GetTransformStatsResponse((List)args[0], (Long)args[1], (List)args[2], (List)args[3]));
    private final List<TransformStats> transformsStats;
    private final long count;
    private final List<TaskOperationFailure> taskFailures;
    private final List<ElasticsearchException> nodeFailures;

    public static GetTransformStatsResponse fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public GetTransformStatsResponse(List<TransformStats> transformsStats, long count, @Nullable List<TaskOperationFailure> taskFailures, @Nullable List<? extends ElasticsearchException> nodeFailures) {
        this.transformsStats = transformsStats;
        this.count = count;
        this.taskFailures = taskFailures == null ? Collections.emptyList() : Collections.unmodifiableList(taskFailures);
        this.nodeFailures = nodeFailures == null ? Collections.emptyList() : Collections.unmodifiableList(nodeFailures);
    }

    public List<TransformStats> getTransformsStats() {
        return this.transformsStats;
    }

    public long getCount() {
        return this.count;
    }

    public List<ElasticsearchException> getNodeFailures() {
        return this.nodeFailures;
    }

    public List<TaskOperationFailure> getTaskFailures() {
        return this.taskFailures;
    }

    public int hashCode() {
        return Objects.hash(this.transformsStats, this.count, this.nodeFailures, this.taskFailures);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        GetTransformStatsResponse that = (GetTransformStatsResponse)other;
        return Objects.equals(this.transformsStats, that.transformsStats) && Objects.equals(this.count, that.count) && Objects.equals(this.nodeFailures, that.nodeFailures) && Objects.equals(this.taskFailures, that.taskFailures);
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), TransformStats.PARSER::apply, TRANSFORMS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), COUNT);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> TaskOperationFailure.fromXContent(p), AcknowledgedTasksResponse.TASK_FAILURES);
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ElasticsearchException.fromXContent(p), AcknowledgedTasksResponse.NODE_FAILURES);
    }
}

