/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.client.ml.dataframe.stats.common;

import java.io.IOException;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Nullable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.ParseField;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.inject.internal.ToStringBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;

public class DataCounts
implements ToXContentObject {
    public static final String TYPE_VALUE = "analytics_data_counts";
    public static final ParseField TRAINING_DOCS_COUNT = new ParseField("training_docs_count", new String[0]);
    public static final ParseField TEST_DOCS_COUNT = new ParseField("test_docs_count", new String[0]);
    public static final ParseField SKIPPED_DOCS_COUNT = new ParseField("skipped_docs_count", new String[0]);
    public static final ConstructingObjectParser<DataCounts, Void> PARSER = new ConstructingObjectParser("analytics_data_counts", true, a -> {
        Long trainingDocsCount = (Long)a[0];
        Long testDocsCount = (Long)a[1];
        Long skippedDocsCount = (Long)a[2];
        return new DataCounts(DataCounts.getOrDefault(trainingDocsCount, 0L), DataCounts.getOrDefault(testDocsCount, 0L), DataCounts.getOrDefault(skippedDocsCount, 0L));
    });
    private final long trainingDocsCount;
    private final long testDocsCount;
    private final long skippedDocsCount;

    public DataCounts(long trainingDocsCount, long testDocsCount, long skippedDocsCount) {
        this.trainingDocsCount = trainingDocsCount;
        this.testDocsCount = testDocsCount;
        this.skippedDocsCount = skippedDocsCount;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(TRAINING_DOCS_COUNT.getPreferredName(), this.trainingDocsCount);
        builder.field(TEST_DOCS_COUNT.getPreferredName(), this.testDocsCount);
        builder.field(SKIPPED_DOCS_COUNT.getPreferredName(), this.skippedDocsCount);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataCounts that = (DataCounts)o;
        return this.trainingDocsCount == that.trainingDocsCount && this.testDocsCount == that.testDocsCount && this.skippedDocsCount == that.skippedDocsCount;
    }

    public int hashCode() {
        return Objects.hash(this.trainingDocsCount, this.testDocsCount, this.skippedDocsCount);
    }

    public String toString() {
        return new ToStringBuilder(this.getClass()).add(TRAINING_DOCS_COUNT.getPreferredName(), this.trainingDocsCount).add(TEST_DOCS_COUNT.getPreferredName(), this.testDocsCount).add(SKIPPED_DOCS_COUNT.getPreferredName(), this.skippedDocsCount).toString();
    }

    public long getTrainingDocsCount() {
        return this.trainingDocsCount;
    }

    public long getTestDocsCount() {
        return this.testDocsCount;
    }

    public long getSkippedDocsCount() {
        return this.skippedDocsCount;
    }

    private static <T> T getOrDefault(@Nullable T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TRAINING_DOCS_COUNT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), TEST_DOCS_COUNT);
        PARSER.declareLong(ConstructingObjectParser.optionalConstructorArg(), SKIPPED_DOCS_COUNT);
    }
}

