/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.admin.indices.settings.put;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ActionRequestValidationException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.IndicesRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.ValidateActions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.IndicesOptions;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.Strings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.settings.Settings;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentObject;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentParser;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentType;

public class UpdateSettingsRequest
extends AcknowledgedRequest<UpdateSettingsRequest>
implements IndicesRequest.Replaceable,
ToXContentObject {
    private String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.fromOptions(false, false, true, true);
    private Settings settings = Settings.Builder.EMPTY_SETTINGS;
    private boolean preserveExisting = false;

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.settings = Settings.readSettingsFromStream(in);
        this.preserveExisting = in.readBoolean();
    }

    public UpdateSettingsRequest() {
    }

    public UpdateSettingsRequest(String ... indices) {
        this.indices = indices;
    }

    public UpdateSettingsRequest(Settings settings, String ... indices) {
        this.indices = indices;
        this.settings = settings;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.settings.isEmpty()) {
            validationException = ValidateActions.addValidationError("no settings to update", validationException);
        }
        return validationException;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Settings settings() {
        return this.settings;
    }

    @Override
    public UpdateSettingsRequest indices(String ... indices) {
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public UpdateSettingsRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public UpdateSettingsRequest settings(Settings settings) {
        this.settings = settings;
        return this;
    }

    public UpdateSettingsRequest settings(Settings.Builder settings) {
        this.settings = settings.build();
        return this;
    }

    public UpdateSettingsRequest settings(String source, XContentType xContentType) {
        this.settings = Settings.builder().loadFromSource(source, xContentType).build();
        return this;
    }

    public boolean isPreserveExisting() {
        return this.preserveExisting;
    }

    public UpdateSettingsRequest setPreserveExisting(boolean preserveExisting) {
        this.preserveExisting = preserveExisting;
        return this;
    }

    public UpdateSettingsRequest settings(Map<String, ?> source) {
        this.settings = Settings.builder().loadFromMap(source).build();
        return this;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        Settings.writeSettingsToStream(this.settings, out);
        out.writeBoolean(this.preserveExisting);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.settings.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public UpdateSettingsRequest fromXContent(XContentParser parser) throws IOException {
        HashMap<String, Object> settings = new HashMap<String, Object>();
        Map<String, Object> bodySettings = parser.map();
        Object innerBodySettings = bodySettings.get("settings");
        if (innerBodySettings instanceof Map) {
            Map innerBodySettingsMap = (Map)innerBodySettings;
            settings.putAll(innerBodySettingsMap);
        } else {
            settings.putAll(bodySettings);
        }
        return this.settings(settings);
    }

    public String toString() {
        return "indices : " + Arrays.toString(this.indices) + "," + Strings.toString(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)o;
        return this.masterNodeTimeout.equals(that.masterNodeTimeout) && this.timeout.equals(that.timeout) && Objects.equals(this.settings, that.settings) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.preserveExisting, that.preserveExisting) && Arrays.equals(this.indices, that.indices);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout, this.timeout, this.settings, this.indicesOptions, this.preserveExisting, Arrays.hashCode(this.indices));
    }
}

