/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.IntBinaryOperator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Accountable;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ArrayUtil;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.ByteBlockPool;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRefIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.Counter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.FutureObjects;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.IntroSorter;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.RamUsageEstimator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.SortableBytesRefArray;

public final class BytesRefArray
implements SortableBytesRefArray {
    private final ByteBlockPool pool;
    private int[] offsets = new int[1];
    private int lastElement = 0;
    private int currentOffset = 0;
    private final Counter bytesUsed;

    public BytesRefArray(Counter bytesUsed) {
        this.pool = new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(bytesUsed));
        this.pool.nextBuffer();
        bytesUsed.addAndGet(RamUsageEstimator.NUM_BYTES_ARRAY_HEADER * 4);
        this.bytesUsed = bytesUsed;
    }

    @Override
    public void clear() {
        this.lastElement = 0;
        this.currentOffset = 0;
        Arrays.fill(this.offsets, 0);
        this.pool.reset(false, true);
    }

    @Override
    public int append(BytesRef bytes) {
        if (this.lastElement >= this.offsets.length) {
            int oldLen = this.offsets.length;
            this.offsets = ArrayUtil.grow(this.offsets, this.offsets.length + 1);
            this.bytesUsed.addAndGet((this.offsets.length - oldLen) * 4);
        }
        this.pool.append(bytes);
        this.offsets[this.lastElement++] = this.currentOffset;
        this.currentOffset += bytes.length;
        return this.lastElement - 1;
    }

    @Override
    public int size() {
        return this.lastElement;
    }

    public BytesRef get(BytesRefBuilder spare, int index) {
        FutureObjects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        spare.grow(length);
        spare.setLength(length);
        this.pool.readBytes(offset, spare.bytes(), 0, spare.length());
        return spare.get();
    }

    private void setBytesRef(BytesRefBuilder spare, BytesRef result, int index) {
        FutureObjects.checkIndex(index, this.lastElement);
        int offset = this.offsets[index];
        int length = index == this.lastElement - 1 ? this.currentOffset - offset : this.offsets[index + 1] - offset;
        this.pool.setBytesRef(spare, result, offset, length);
    }

    public SortState sort(final Comparator<BytesRef> comp, final IntBinaryOperator tieComparator) {
        final int[] orderedEntries = new int[this.size()];
        for (int i = 0; i < orderedEntries.length; ++i) {
            orderedEntries[i] = i;
        }
        new IntroSorter(){
            private int pivotIndex;
            private final BytesRef pivot = new BytesRef();
            private final BytesRef scratchBytes1 = new BytesRef();
            private final BytesRef scratchBytes2 = new BytesRef();
            private final BytesRefBuilder pivotBuilder = new BytesRefBuilder();
            private final BytesRefBuilder scratch1 = new BytesRefBuilder();
            private final BytesRefBuilder scratch2 = new BytesRefBuilder();

            @Override
            protected void swap(int i, int j) {
                int o = orderedEntries[i];
                orderedEntries[i] = orderedEntries[j];
                orderedEntries[j] = o;
            }

            @Override
            protected int compare(int i, int j) {
                int idx1 = orderedEntries[i];
                int idx2 = orderedEntries[j];
                BytesRefArray.this.setBytesRef(this.scratch1, this.scratchBytes1, idx1);
                BytesRefArray.this.setBytesRef(this.scratch2, this.scratchBytes2, idx2);
                return this.compare(idx1, this.scratchBytes1, idx2, this.scratchBytes2);
            }

            @Override
            protected void setPivot(int i) {
                this.pivotIndex = orderedEntries[i];
                BytesRefArray.this.setBytesRef(this.pivotBuilder, this.pivot, this.pivotIndex);
            }

            @Override
            protected int comparePivot(int j) {
                int index = orderedEntries[j];
                BytesRefArray.this.setBytesRef(this.scratch2, this.scratchBytes2, index);
                return this.compare(this.pivotIndex, this.pivot, index, this.scratchBytes2);
            }

            private int compare(int i1, BytesRef b1, int i2, BytesRef b2) {
                int res = comp.compare(b1, b2);
                return res == 0 ? tieComparator.applyAsInt(i1, i2) : res;
            }
        }.sort(0, this.size());
        return new SortState(orderedEntries);
    }

    public BytesRefIterator iterator() {
        return this.iterator((SortState)null);
    }

    @Override
    public BytesRefIterator iterator(Comparator<BytesRef> comp) {
        return this.iterator(this.sort(comp, (i, j) -> 0));
    }

    public IndexedBytesRefIterator iterator(SortState sortState) {
        int[] indices;
        final int size = this.size();
        int[] nArray = indices = sortState == null ? null : sortState.indices;
        assert (indices == null || indices.length == size) : indices.length + " != " + size;
        final BytesRefBuilder spare = new BytesRefBuilder();
        final BytesRef result = new BytesRef();
        return new IndexedBytesRefIterator(){
            int pos = -1;
            int ord = 0;

            @Override
            public BytesRef next() {
                ++this.pos;
                if (this.pos < size) {
                    this.ord = indices == null ? this.pos : indices[this.pos];
                    BytesRefArray.this.setBytesRef(spare, result, this.ord);
                    return result;
                }
                return null;
            }

            @Override
            public int ord() {
                return this.ord;
            }
        };
    }

    public static interface IndexedBytesRefIterator
    extends BytesRefIterator {
        public int ord();
    }

    public static final class SortState
    implements Accountable {
        private final int[] indices;

        private SortState(int[] indices) {
            this.indices = indices;
        }

        @Override
        public long ramBytesUsed() {
            return RamUsageEstimator.NUM_BYTES_ARRAY_HEADER + this.indices.length * 4;
        }
    }
}

