/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.slice;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReader;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.PostingsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Terms;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.TermsEnum;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ConstantScoreScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ConstantScoreWeight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSet;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.DocIdSetIterator;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.IndexSearcher;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreMode;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.DocIdSetBuilder;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.StringHelper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.slice.SliceQuery;

public final class TermsSliceQuery
extends SliceQuery {
    public static final int SEED = 7919;

    public TermsSliceQuery(String field, int id, int max) {
        super(field, id, max);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                DocIdSet disi = TermsSliceQuery.this.build(context.reader());
                DocIdSetIterator leafIt = disi.iterator();
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, leafIt);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    private DocIdSet build(LeafReader reader) throws IOException {
        DocIdSetBuilder builder = new DocIdSetBuilder(reader.maxDoc());
        Terms terms = reader.terms(this.getField());
        if (terms == null) {
            return DocIdSet.EMPTY;
        }
        TermsEnum te = terms.iterator();
        PostingsEnum docsEnum = null;
        BytesRef term = te.next();
        while (term != null) {
            int hashCode = StringHelper.murmurhash3_x86_32(term, 7919);
            if (this.contains(hashCode)) {
                docsEnum = te.postings(docsEnum, 0);
                builder.add(docsEnum);
            }
            term = te.next();
        }
        return builder.build();
    }
}

