/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.rescore;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScoreDoc;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TopDocs;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.ElasticsearchException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.search.TopDocsAndMaxScore;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.internal.SearchContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.rescore.RescoreContext;

public class RescorePhase {
    public void execute(SearchContext context) {
        TopDocs topDocs = context.queryResult().topDocs().topDocs;
        if (topDocs.scoreDocs.length == 0) {
            return;
        }
        try {
            for (RescoreContext ctx : context.rescore()) {
                topDocs = ctx.rescorer().rescore(topDocs, context.searcher(), ctx);
                assert (context.sort() == null && this.topDocsSortedByScore(topDocs)) : "topdocs should be sorted after rescore";
            }
            context.queryResult().topDocs(new TopDocsAndMaxScore(topDocs, topDocs.scoreDocs[0].score), context.queryResult().sortValueFormats());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Rescore Phase Failed", (Throwable)e, new Object[0]);
        }
    }

    private boolean topDocsSortedByScore(TopDocs topDocs) {
        if (topDocs == null || topDocs.scoreDocs == null || topDocs.scoreDocs.length < 2) {
            return true;
        }
        float lastScore = topDocs.scoreDocs[0].score;
        for (int i = 1; i < topDocs.scoreDocs.length; ++i) {
            ScoreDoc doc = topDocs.scoreDocs[i];
            if (Float.compare(doc.score, lastScore) > 0) {
                return false;
            }
            lastScore = doc.score;
        }
        return true;
    }
}

