/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query;

import java.io.IOException;
import java.util.Set;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.LeafReaderContext;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BulkScorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Explanation;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Scorer;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ScorerSupplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Weight;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.Timer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.ProfileScorer;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.QueryProfileBreakdown;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.profile.query.QueryTimingType;

public final class ProfileWeight
extends Weight {
    private final Weight subQueryWeight;
    private final QueryProfileBreakdown profile;

    public ProfileWeight(Query query, Weight subQueryWeight, QueryProfileBreakdown profile) throws IOException {
        super(query);
        this.subQueryWeight = subQueryWeight;
        this.profile = profile;
    }

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        ScorerSupplier supplier = this.scorerSupplier(context);
        if (supplier == null) {
            return null;
        }
        return supplier.get(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
        ScorerSupplier subQueryScorerSupplier;
        final Timer timer = this.profile.getTimer(QueryTimingType.BUILD_SCORER);
        timer.start();
        try {
            subQueryScorerSupplier = this.subQueryWeight.scorerSupplier(context);
        }
        finally {
            timer.stop();
        }
        if (subQueryScorerSupplier == null) {
            return null;
        }
        final ProfileWeight weight = this;
        return new ScorerSupplier(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Scorer get(long loadCost) throws IOException {
                timer.start();
                try {
                    ProfileScorer profileScorer = new ProfileScorer(weight, subQueryScorerSupplier.get(loadCost), ProfileWeight.this.profile);
                    return profileScorer;
                }
                finally {
                    timer.stop();
                }
            }

            @Override
            public long cost() {
                timer.start();
                try {
                    long l = subQueryScorerSupplier.cost();
                    return l;
                }
                finally {
                    timer.stop();
                }
            }
        };
    }

    @Override
    public BulkScorer bulkScorer(LeafReaderContext context) throws IOException {
        return super.bulkScorer(context);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        return this.subQueryWeight.explain(context, doc);
    }

    @Override
    public void extractTerms(Set<Term> set) {
        this.subQueryWeight.extractTerms(set);
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return false;
    }
}

