/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.join.mapper;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.Field;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.FieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.document.SortedDocValuesField;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexOptions;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.IndexableFieldType;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.index.Term;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanClause;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.BooleanQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.ConstantScoreQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.Query;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.search.TermQuery;
import org.apache.flink.elasticsearch7.shaded.org.apache.lucene.util.BytesRef;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.lucene.Lucene;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.IndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.fielddata.plain.SortedSetOrdinalsIndexFieldData;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.FieldMapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MappedFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.Mapper;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.MapperService;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ParseContext;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.StringFieldType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.TextSearchInfo;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.index.mapper.ValueFetcher;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.search.lookup.SearchLookup;

public final class ParentIdFieldMapper
extends FieldMapper {
    static final String CONTENT_TYPE = "parent";
    private final String parentName;
    private Set<String> children;

    protected ParentIdFieldMapper(String simpleName, String parentName, Set<String> children, FieldType fieldType, MappedFieldType mappedFieldType) {
        super(simpleName, fieldType, mappedFieldType, FieldMapper.MultiFields.empty(), FieldMapper.CopyTo.empty());
        this.parentName = parentName;
        this.children = children;
    }

    @Override
    protected ParentIdFieldMapper clone() {
        return (ParentIdFieldMapper)super.clone();
    }

    public String getParentName() {
        return this.parentName;
    }

    public Query getParentFilter() {
        return new TermQuery(new Term(this.name().substring(0, this.name().indexOf(35)), this.parentName));
    }

    public Collection<String> getChildren() {
        return this.children;
    }

    public Query getChildFilter(String type) {
        return new TermQuery(new Term(this.name().substring(0, this.name().indexOf(35)), type));
    }

    public Query getChildrenFilter() {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String child : this.children) {
            builder.add(this.getChildFilter(child), BooleanClause.Occur.SHOULD);
        }
        return new ConstantScoreQuery(builder.build());
    }

    @Override
    protected void parseCreateField(ParseContext context) throws IOException {
        if (!context.externalValueSet()) {
            throw new IllegalStateException("external value not set");
        }
        String refId = (String)context.externalValue();
        BytesRef binaryValue = new BytesRef(refId);
        Field field = new Field(this.fieldType().name(), binaryValue, (IndexableFieldType)this.fieldType);
        context.doc().add(field);
        context.doc().add(new SortedDocValuesField(this.fieldType().name(), binaryValue));
    }

    @Override
    protected void mergeOptions(FieldMapper other, List<String> conflicts) {
        ParentIdFieldMapper parentMergeWith = (ParentIdFieldMapper)other;
        this.children = parentMergeWith.children;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    public static final class ParentIdFieldType
    extends StringFieldType {
        private ParentIdFieldType(String name, boolean eagerGlobalOrdinals, Map<String, String> meta) {
            super(name, true, false, true, TextSearchInfo.SIMPLE_MATCH_ONLY, meta);
            this.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            this.setEagerGlobalOrdinals(eagerGlobalOrdinals);
        }

        @Override
        public String typeName() {
            return ParentIdFieldMapper.CONTENT_TYPE;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
            this.failIfNoDocValues();
            return new SortedSetOrdinalsIndexFieldData.Builder(this.name(), CoreValuesSourceType.BYTES);
        }

        @Override
        public ValueFetcher valueFetcher(MapperService mapperService, SearchLookup searchLookup, String format) {
            throw new UnsupportedOperationException("Cannot fetch values for internal field [" + this.typeName() + "].");
        }

        @Override
        public Object valueForDisplay(Object value) {
            if (value == null) {
                return null;
            }
            BytesRef binaryValue = (BytesRef)value;
            return binaryValue.utf8ToString();
        }
    }

    static class Builder
    extends FieldMapper.Builder<Builder> {
        private final String parent;
        private final Set<String> children;

        Builder(String name, String parent, Set<String> children) {
            super(name, Defaults.FIELD_TYPE);
            this.builder = this;
            this.parent = parent;
            this.children = children;
        }

        public Set<String> getChildren() {
            return this.children;
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.eagerGlobalOrdinals = eagerGlobalOrdinals;
            return (Builder)this.builder;
        }

        @Override
        public ParentIdFieldMapper build(Mapper.BuilderContext context) {
            return new ParentIdFieldMapper(this.name, this.parent, this.children, this.fieldType, new ParentIdFieldType(this.buildFullName(context), this.eagerGlobalOrdinals, this.meta));
        }
    }

    static class Defaults {
        static final FieldType FIELD_TYPE = new FieldType();

        Defaults() {
        }

        static {
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.freeze();
        }
    }
}

