/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery;

import java.io.IOException;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.Version;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamInput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.StreamOutput;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.io.stream.Writeable;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContent;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.ToXContentFragment;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentBuilder;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.PendingClusterStateStats;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.discovery.zen.PublishClusterStateStats;

public class DiscoveryStats
implements Writeable,
ToXContentFragment {
    private final PendingClusterStateStats queueStats;
    private final PublishClusterStateStats publishStats;

    public DiscoveryStats(PendingClusterStateStats queueStats, PublishClusterStateStats publishStats) {
        this.queueStats = queueStats;
        this.publishStats = publishStats;
    }

    public DiscoveryStats(StreamInput in) throws IOException {
        this.queueStats = in.readOptionalWriteable(PendingClusterStateStats::new);
        this.publishStats = in.getVersion().onOrAfter(Version.V_6_1_0) ? in.readOptionalWriteable(PublishClusterStateStats::new) : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.queueStats);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalWriteable(this.publishStats);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("discovery");
        if (this.queueStats != null) {
            this.queueStats.toXContent(builder, params);
        }
        if (this.publishStats != null) {
            this.publishStats.toXContent(builder, params);
        }
        builder.endObject();
        return builder;
    }

    public PendingClusterStateStats getQueueStats() {
        return this.queueStats;
    }

    public PublishClusterStateStats getPublishStats() {
        return this.publishStats;
    }

    static final class Fields {
        static final String DISCOVERY = "discovery";

        Fields() {
        }
    }
}

