/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent;

import java.util.function.Supplier;
import org.apache.flink.elasticsearch7.shaded.org.elasticsearch.common.xcontent.XContentLocation;

public interface DeprecationHandler {
    public static final DeprecationHandler THROW_UNSUPPORTED_OPERATION = new DeprecationHandler(){

        @Override
        public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + usedName + "] at [" + location.get() + "] which is a deprecated name for [" + replacedWith + "]");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + usedName + "] which is a deprecated name for [" + replacedWith + "]");
        }

        @Override
        public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + usedName + "] at [" + location.get() + "] which has been replaced with [" + modernName + "]");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + usedName + "] which has been replaced with [" + modernName + "]");
        }

        @Override
        public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
            if (parserName != null) {
                throw new UnsupportedOperationException("deprecated fields not supported in [" + parserName + "] but got [" + usedName + "] at [" + location.get() + "] which has been deprecated entirely");
            }
            throw new UnsupportedOperationException("deprecated fields not supported here but got [" + usedName + "] which has been deprecated entirely");
        }
    };
    public static final DeprecationHandler IGNORE_DEPRECATIONS = new DeprecationHandler(){

        @Override
        public void usedDeprecatedName(String parserName, Supplier<XContentLocation> location, String usedName, String modernName) {
        }

        @Override
        public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName, String replacedWith) {
        }

        @Override
        public void usedDeprecatedField(String parserName, Supplier<XContentLocation> location, String usedName) {
        }
    };

    public void usedDeprecatedName(String var1, Supplier<XContentLocation> var2, String var3, String var4);

    public void usedDeprecatedField(String var1, Supplier<XContentLocation> var2, String var3, String var4);

    public void usedDeprecatedField(String var1, Supplier<XContentLocation> var2, String var3);
}

